/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.gpuimage;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import com.vhall.vhallrtc.gpuimage.GPUImageFilter;
import com.vhall.vhallrtc.gpuimage.TextureRotationUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class GPUImageFilterGroup
extends GPUImageFilter {
    protected List<GPUImageFilter> mFilters;
    protected List<GPUImageFilter> mMergedFilters;
    private int[] mFrameBuffers;
    private int[] mFrameBufferTextures;
    private final FloatBuffer mGLCubeBuffer;
    private final FloatBuffer mGLTextureBuffer;

    public GPUImageFilterGroup() {
        this(null);
    }

    public GPUImageFilterGroup(List<GPUImageFilter> filters) {
        this.mFilters = filters;
        if (this.mFilters == null) {
            this.mFilters = new ArrayList<GPUImageFilter>();
        } else {
            this.updateMergedFilters();
        }
        this.mGLCubeBuffer = ByteBuffer.allocateDirect(VERTEX_CUBE_NORMAL.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLCubeBuffer.put(VERTEX_CUBE_NORMAL).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
    }

    public void addFilter(GPUImageFilter aFilter) {
        if (aFilter == null) {
            return;
        }
        this.mFilters.add(aFilter);
        this.updateMergedFilters();
    }

    @Override
    public void onInit() {
        super.onInit();
        for (GPUImageFilter filter : this.mFilters) {
            filter.init();
        }
    }

    @Override
    public void onDestroy() {
        this.destroyFramebuffers();
        for (GPUImageFilter filter : this.mFilters) {
            filter.destroy();
        }
        super.onDestroy();
    }

    private void destroyFramebuffers() {
        if (this.mFrameBufferTextures != null) {
            GLES20.glDeleteTextures((int)this.mFrameBufferTextures.length, (int[])this.mFrameBufferTextures, (int)0);
            this.mFrameBufferTextures = null;
        }
        if (this.mFrameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)this.mFrameBuffers.length, (int[])this.mFrameBuffers, (int)0);
            this.mFrameBuffers = null;
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (this.mFrameBuffers != null) {
            this.destroyFramebuffers();
        }
        int size = this.mFilters.size();
        for (int i = 0; i < size; ++i) {
            this.mFilters.get(i).onOutputSizeChanged(width, height);
        }
        if (this.mMergedFilters != null && this.mMergedFilters.size() > 0) {
            size = this.mMergedFilters.size();
            this.mFrameBuffers = new int[size - 1];
            this.mFrameBufferTextures = new int[size - 1];
            int[] currFbo = new int[1];
            GLES20.glGetIntegerv((int)36006, (int[])currFbo, (int)0);
            for (int i = 0; i < size - 1; ++i) {
                GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffers, (int)i);
                GLES20.glGenTextures((int)1, (int[])this.mFrameBufferTextures, (int)i);
                GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextures[i]);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[i]);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextures[i], (int)0);
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)currFbo[0]);
            }
        }
    }

    @Override
    @SuppressLint(value={"WrongCall"})
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        this.runPendingOnDrawTasks();
        if (!this.isInitialized() || this.mFrameBuffers == null || this.mFrameBufferTextures == null) {
            return;
        }
        if (this.mMergedFilters != null) {
            int size = this.mMergedFilters.size();
            int previousTexture = textureId;
            int[] currFbo = new int[1];
            GLES20.glGetIntegerv((int)36006, (int[])currFbo, (int)0);
            for (int i = 0; i < size; ++i) {
                boolean isNotLast;
                GPUImageFilter filter = this.mMergedFilters.get(i);
                boolean bl = isNotLast = i < size - 1;
                if (isNotLast) {
                    GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[i]);
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 0) {
                    filter.onDraw(previousTexture, cubeBuffer, textureBuffer);
                } else {
                    filter.onDraw(previousTexture, this.mGLCubeBuffer, this.mGLTextureBuffer);
                }
                if (!isNotLast) continue;
                GLES20.glBindFramebuffer((int)36160, (int)currFbo[0]);
                previousTexture = this.mFrameBufferTextures[i];
            }
        }
    }

    public List<GPUImageFilter> getFilters() {
        return this.mFilters;
    }

    public List<GPUImageFilter> getMergedFilters() {
        return this.mMergedFilters;
    }

    public void updateMergedFilters() {
        if (this.mFilters == null) {
            return;
        }
        if (this.mMergedFilters == null) {
            this.mMergedFilters = new ArrayList<GPUImageFilter>();
        } else {
            this.mMergedFilters.clear();
        }
        for (GPUImageFilter filter : this.mFilters) {
            if (filter instanceof GPUImageFilterGroup) {
                ((GPUImageFilterGroup)filter).updateMergedFilters();
                List<GPUImageFilter> filters = ((GPUImageFilterGroup)filter).getMergedFilters();
                if (filters == null || filters.isEmpty()) continue;
                this.mMergedFilters.addAll(filters);
                continue;
            }
            this.mMergedFilters.add(filter);
        }
    }
}

