/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.gpuimage;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.vhall.vhallrtc.gpuimage.GPUImageFilter;

public class GPUImageCameraInputFilter
extends GPUImageFilter {
    public static final String EXT_TEXTURE_INPUT_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\n\nvarying highp vec2 textureCoordinate;\n \nuniform samplerExternalOES inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    private int mInputTextureId = -1;
    private SurfaceTexture mInputSurfaceTexture;

    public GPUImageCameraInputFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", EXT_TEXTURE_INPUT_FRAGMENT_SHADER);
    }

    @Override
    public void onInit() {
        super.onInit();
        int[] textureid = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureid, (int)0);
        this.mInputTextureId = textureid[0];
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.mInputTextureId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GLES20.glBindTexture((int)36197, (int)0);
        this.mInputSurfaceTexture = new SurfaceTexture(this.mInputTextureId);
    }

    @Override
    protected void onDrawArraysPre() {
        super.onDrawArraysPre();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.mInputTextureId);
        GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
    }

    @Override
    public void onDestroy() {
        this.mInputSurfaceTexture.release();
        this.mInputSurfaceTexture = null;
        GLES20.glBindTexture((int)36197, (int)0);
        int[] textureid = new int[]{this.mInputTextureId};
        GLES20.glDeleteTextures((int)1, (int[])textureid, (int)0);
        this.mInputTextureId = -1;
        super.onDestroy();
    }

    public SurfaceTexture getInputSurfaceTexture() {
        return this.mInputSurfaceTexture;
    }
}

