/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.document;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.vhall.document.IDocument;
import com.vhall.logmanager.VLog;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONException;
import org.json.JSONObject;

public class DocumentView
extends WebView
implements IDocument {
    private static final String TAG = "DocumentView";
    private static String HOST = "https://static.vhallyun.com/jssdk/doc-sdk/dist/1.4.6/mobile.html";
    public static final int EVENT_PAGE_LOADED = 1;
    public static final int EVENT_DOC_LOADED = 2;
    public static final int EVENT_DOODLE = 4;
    public static final int EVENT_DOODLE_BACK = 6;
    public static final int EVENT_LOADED_FAILED = 5;
    private WebSettings mSettings;
    private int mWidth = 0;
    private int mHeight = 0;
    private double initWidth = 0.0;
    private double initHeight = 0.0;
    private static final String JSNAME = "doodlesdk";
    private IDocument.Mode mMode = IDocument.Mode.DOCUMENT;
    private IDocument.DrawType mType = IDocument.DrawType.PATH;
    private IDocument.DrawAction mAction = IDocument.DrawAction.ADD;
    private boolean mEditable = false;
    private boolean mCacheable = false;
    private Context mContext;
    private boolean mReady = false;
    private final CopyOnWriteArraySet<EventListener> listeners = new CopyOnWriteArraySet();
    private int mRetryTimes = 5;
    public static String backgroundColor = "#ffffff";
    private String cid = "";
    private String docId = "";
    private String opts = "";
    private String type = "document";
    public static final String DOC_BOARD = "board";
    public static final String DOC_DOCUMENT = "document";
    private Handler handler;
    private String mWatermark = "";
    private boolean ignoreSSLWarning = false;

    public int getmWidth() {
        return this.mWidth;
    }

    public int getmHeight() {
        return this.mHeight;
    }

    public double getInitHeight() {
        return this.initHeight;
    }

    public double getInitWidth() {
        return this.initWidth;
    }

    public static void setHost(String host) {
        if (!TextUtils.isEmpty((CharSequence)host)) {
            HOST = host;
        }
    }

    public boolean isReady() {
        return this.mReady;
    }

    public boolean isCacheable() {
        return this.mCacheable;
    }

    public boolean isEditable() {
        return this.mEditable;
    }

    public DocumentView(Context context) {
        super(context);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.initConfig(context);
    }

    public DocumentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initConfig(context);
    }

    public DocumentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initConfig(context);
    }

    private void initConfig(Context context) {
        this.ignoreSSLWarning = true;
        this.handler = new Handler();
        this.mContext = context;
        this.mSettings = this.getSettings();
        this.mSettings.setJavaScriptEnabled(true);
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.mSettings.setAllowFileAccess(true);
        this.mSettings.setBlockNetworkImage(false);
        this.mSettings.setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        this.addJavascriptInterface(new DoodleJS(), JSNAME);
        this.setWebViewClient(new MyWebViewClient());
        this.setWebChromeClient(new MyWebChromeClient());
        this.loadUrl(HOST);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.getLayoutParams().width = -1;
        this.getLayoutParams().height = -1;
        this.setLayoutParams(this.getLayoutParams());
    }

    @Override
    public void init(String cid, String opts) {
        this.cid = cid;
        this.opts = opts;
        this.computeScaling(opts);
    }

    @Override
    public void createBoard(String userId) {
        if (this.cid == null || TextUtils.isEmpty((CharSequence)this.opts)) {
            throw new IllegalStateException("please init document first !");
        }
        this.type = DOC_BOARD;
        this.executeJS("createBoard('" + this.cid + "','" + this.opts + "')");
        this.executeJS("passThrough('" + userId + "','" + this.docId + "')");
        this.setSize(DocumentView.px2dp(this.mContext, this.mWidth), DocumentView.px2dp(this.mContext, this.mHeight));
    }

    @Override
    public void createDocument(String userId, String docId) {
        this.docId = docId;
        if (this.cid == null || TextUtils.isEmpty((CharSequence)this.opts)) {
            throw new IllegalStateException("please document init first !");
        }
        this.type = DOC_DOCUMENT;
        this.executeJS("createDocument('" + this.cid + "','" + this.opts + "')");
        VLog.d((String)"Watermark", (String)("createDocument('" + this.cid + "','" + this.opts + "')"));
        this.executeJS("passThrough('" + userId + "','" + docId + "')");
        this.setSize(DocumentView.px2dp(this.mContext, this.mWidth), DocumentView.px2dp(this.mContext, this.mHeight));
    }

    @Override
    public void setWatermark(String watermark) {
        this.mWatermark = watermark;
    }

    private boolean isDocument() {
        return this.type == DOC_DOCUMENT;
    }

    private void computeScaling(String opts) {
        try {
            JSONObject obj = new JSONObject(opts);
            JSONObject basic = obj.optJSONObject("basic");
            this.initWidth = basic.optDouble("width");
            this.initHeight = basic.optDouble("height");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAllPageData(String jsonArray) {
        this.executeJS("setAllPageData('" + jsonArray + "')");
    }

    @Override
    public void setIsVod(boolean isVod) {
        this.executeJS("setIsVod(" + isVod + ")");
    }

    @Override
    public void vodTime(double time) {
        this.executeJS("vodTime(" + time + ")");
    }

    @Override
    public void vodData(String json) {
        this.executeJS("vodData('" + json + "')");
    }

    @Override
    public void vodAllCids() {
        this.executeJS("vodAllCids()");
    }

    @Override
    public void vodAllWatchStatus() {
        this.executeJS("vodAllWatchStatus()");
    }

    @Override
    public void setEditable(boolean editable) {
        this.mEditable = editable;
        this.executeJS("editable(" + this.mEditable + ")");
    }

    @Override
    @Deprecated
    public void setCacheable(boolean cacheable) {
    }

    @Override
    public void setSize(final int width, final int height) {
        long delay;
        if (width <= 0 || height <= 0) {
            return;
        }
        this.executeJS("resize(" + width + "," + height + ")");
        long l = delay = this.isDocument() ? 1000L : 0L;
        if (null != this.handler) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!TextUtils.isEmpty((CharSequence)DocumentView.this.mWatermark)) {
                        DocumentView.this.executeJS("setWatermark('" + DocumentView.this.mWatermark + "')");
                        VLog.d((String)"Watermark", (String)("setWatermark('" + DocumentView.this.mWatermark + "')"));
                    }
                    DocumentView.this.executeJS("resize(" + width + "," + height + ")");
                    VLog.d((String)"Watermark", (String)("resize(" + width + "," + height + ")"));
                }
            }, delay);
        }
    }

    @Override
    public void setMode(IDocument.Mode mode) {
        this.mMode = mode;
    }

    @Override
    public void setWhiteboardColor(int color) {
        if (!this.mEditable) {
            return;
        }
        if (this.mMode != IDocument.Mode.WHITEBOARD) {
            return;
        }
        this.executeJS("setBackgroundColor('" + color + "')");
    }

    @Override
    public void setAction(IDocument.DrawAction action) {
        if (!this.mEditable) {
            return;
        }
        this.mAction = action;
        switch (this.mAction) {
            case ADD: {
                this.executeJS("confirm(" + this.mType.getCode() + ")");
                break;
            }
            case MODIFY: {
                this.executeJS("confirm(-1)");
                break;
            }
            case DELETE: {
                this.executeJS("eraser()");
            }
        }
    }

    @Override
    public void setDrawType(IDocument.DrawType type) {
        if (!this.mEditable) {
            return;
        }
        this.mType = type;
        this.executeJS("confirm(" + type.getCode() + ")");
    }

    @Override
    public void setDrawOption(String color, int size) {
        if (!this.mEditable) {
            return;
        }
        try {
            JSONObject object = new JSONObject();
            object.put("stroke", (Object)color);
            object.put("strokeWidth", size);
            this.executeJS("onOptionSettingHandler(" + object.toString() + ")");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clear() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("clear()");
    }

    @Override
    public void uploadImage(String imgurl) {
    }

    @Override
    public void doodle(String json) {
        this.executeJS("setData('" + json + "')");
    }

    @Override
    public void setDoc(String hash, String opts) {
        if (TextUtils.isEmpty((CharSequence)hash)) {
            return;
        }
        this.executeJS("setDoc('" + hash + "','" + opts + "')");
        VLog.d((String)"Watermark", (String)("setDoc('" + hash + "','" + opts + "')"));
        this.setAction(this.mAction);
        this.setDrawType(this.mType);
        this.notifyListener(2, opts);
    }

    @Override
    public void preSlide() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("prevPage()");
    }

    @Override
    public void nextSlide() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("nextPage()");
    }

    @Override
    public void gotoSlide(int page) {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("gotoPage(" + page + ")");
    }

    @Override
    public void preStep() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("prevStep()");
    }

    @Override
    public void nextStep() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("nextStep()");
    }

    @Override
    public void undo() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("undo()");
    }

    @Override
    public void redo() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("redo()");
    }

    @Override
    public void resetUndoManagerData() {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("resetUndoManagerData()");
    }

    @Override
    public void gotoStep(int step) {
        if (!this.mEditable) {
            return;
        }
        this.executeJS("gotoStep(" + step + ")");
    }

    @TargetApi(value=19)
    private void executeJS(String code) {
        String url = "javascript:" + code;
        VLog.d((String)TAG, (String)url);
        this.evaluateJavascript(url, (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String value) {
            }
        });
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        if (w == this.mWidth && h == this.mHeight) {
            return;
        }
        if (w > 0 && h > 0) {
            if ((double)(1.0f * (float)w / (float)h) > 1.0 * this.initWidth / this.initHeight) {
                this.mHeight = h;
                this.mWidth = (int)((double)this.mHeight * this.initWidth / this.initHeight);
            } else if ((double)(1.0f * (float)w / (float)h) < 1.0 * this.initWidth / this.initHeight) {
                this.mWidth = w;
                this.mHeight = (int)((double)this.mWidth * this.initHeight / this.initWidth);
            } else {
                this.mWidth = w;
                this.mHeight = h;
            }
            this.setSize(DocumentView.px2dp(this.mContext, this.mWidth), DocumentView.px2dp(this.mContext, this.mHeight));
            if (null != this.handler) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        DocumentView.this.getLayoutParams().width = DocumentView.this.mWidth;
                        DocumentView.this.getLayoutParams().height = DocumentView.this.mHeight;
                        DocumentView.this.setLayoutParams(DocumentView.this.getLayoutParams());
                    }
                });
            }
        }
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public void addListener(EventListener listener) {
        if (null != this.listeners) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(EventListener listener) {
        if (null != this.listeners) {
            this.listeners.remove(listener);
        }
    }

    public void notifyListener(int code, String msg) {
        for (EventListener listener : this.listeners) {
            listener.onEvent(code, msg);
        }
    }

    public String getCid() {
        return this.cid;
    }

    public String getType() {
        return this.type;
    }

    public String getDocId() {
        return this.docId;
    }

    public void destroy() {
        if (null != this.listeners) {
            this.listeners.clear();
        }
        if (null != this.handler) {
            this.handler = null;
        }
        super.destroy();
    }

    public static interface EventListener {
        public void onEvent(int var1, String var2);
    }

    class MyWebChromeClient
    extends WebChromeClient {
        MyWebChromeClient() {
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            switch (consoleMessage.messageLevel()) {
                case ERROR: {
                    VLog.d((String)DocumentView.TAG, (String)("onConsoleMessageError: " + consoleMessage.message() + " level=" + consoleMessage.messageLevel()));
                }
            }
            return super.onConsoleMessage(consoleMessage);
        }
    }

    class MyWebViewClient
    extends WebViewClient {
        MyWebViewClient() {
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            VLog.e((String)DocumentView.TAG, (String)"onReceivedError: ");
        }

        @SuppressLint(value={"WebViewClientOnReceivedSslError"})
        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            VLog.d((String)DocumentView.TAG, (String)("onReceivedSslError: " + error.toString()));
            if (null != handler) {
                if (DocumentView.this.ignoreSSLWarning) {
                    handler.proceed();
                } else {
                    handler.cancel();
                }
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (!url.contains("/jssdk/doc-sdk/dist/")) {
                if (DocumentView.this.mRetryTimes > 0) {
                    view.loadUrl(HOST);
                    DocumentView.this.mRetryTimes--;
                } else {
                    DocumentView.this.notifyListener(5, "\u52a0\u8f7d\u5931\u8d25,\u8bf7\u91cd\u8bd5");
                }
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            DocumentView.this.mReady = true;
            DocumentView.this.notifyListener(1, "\u754c\u9762\u52a0\u8f7d\u5b8c\u6210");
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            String url = null;
            if (Build.VERSION.SDK_INT >= 21) {
                url = request.getUrl().toString();
            }
            if (!TextUtils.isEmpty(url) && !url.contains("/jssdk/doc-sdk/dist/")) {
                if (DocumentView.this.mRetryTimes > 0) {
                    view.loadUrl(HOST);
                    DocumentView.this.mRetryTimes--;
                } else {
                    DocumentView.this.notifyListener(5, "\u52a0\u8f7d\u5931\u8d25,\u8bf7\u91cd\u8bd5");
                }
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }

    class DoodleJS {
        DoodleJS() {
        }

        @JavascriptInterface
        public void toServer(final String data) {
            if (!TextUtils.isEmpty((CharSequence)data)) {
                DocumentView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        DocumentView.this.notifyListener(6, data);
                    }
                });
            }
        }

        @JavascriptInterface
        public void toServerEvent(final String data) {
            if (!TextUtils.isEmpty((CharSequence)data)) {
                DocumentView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        DocumentView.this.notifyListener(4, data);
                    }
                });
            }
        }
    }
}

