/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.jni;

import com.vhall.jni.HttpRequest;
import com.vhall.jni.VideoInfo;

public class VhallLiveObs {
    private static final String TAG = "VhallLiveObs";
    public static final int OK_PublishConnect = 0;
    public static final int ERROR_PublishConnect = 1;
    public static final int OK_WatchConnect = 2;
    public static final int ERROR_WatchConnect = 3;
    public static final int StartBuffering = 4;
    public static final int StopBuffering = 5;
    public static final int ERROR_Param = 6;
    public static final int ERROR_Recv = 7;
    public static final int ERROR_Send = 8;
    public static final int INFO_Speed_Upload = 9;
    public static final int INFO_Speed_Download = 10;
    public static final int INFO_NetWork_Status = 11;
    public static final int INFO_Decoded_Video = 12;
    public static final int INFO_Decoded_Audio = 13;
    public static final int Upload_Network_Exception = 14;
    public static final int Upload_Network_OK = 15;
    public static final int CDN_Start_Switch = 16;
    public static final int Recv_Stream_Type = 17;
    public static final int VIDEO_QUEUE_FULL = 18;
    public static final int AUDIO_QUEUE_FULL = 19;
    public static final int VIDEO_ENCODE_BUSY = 20;
    public static final int VIDEO_ENCODE_OK = 21;
    public static final int RECONNECTING = 22;
    public static final int ONCUEPOINT_AMF_MSG = 23;
    public static final int AUDIO_RECORD_INIT_ERROR = 101;
    public static final int HWDecoder_Video_Init = 101;
    public static final int HWDecoder_Video_Destory = 102;
    public static final int DEMUX_METADATA_SUCCESS = 201;
    public static final int HTTPS_REQUEST_MSG = 202;
    private LiveCallback mObserver = null;

    public VhallLiveObs(LiveCallback observer) {
        this.mObserver = observer;
    }

    public void onEvent(int type, String content) {
        if (type == 202) {
            HttpRequest.httpGetAsyncRequest(content);
            return;
        }
        if (this.mObserver != null) {
            this.mObserver.notifyEvent(type, content);
        }
    }

    public void onRawVideo(byte[] data, int size, int w, int h) {
        if (this.mObserver != null) {
            this.mObserver.notifyVideoData(data, w, h);
        }
    }

    public int onRawAudio(byte[] data, int size) {
        if (this.mObserver != null) {
            return this.mObserver.notifyAudioData(data, size);
        }
        return -1;
    }

    public int onHWDecodeVideo(byte[] data, int size, int width, int height, long ts) {
        if (this.mObserver != null) {
            this.mObserver.onHardDecodeVideoData(data, size, width, height, ts);
        }
        return 1;
    }

    public Object getHWDecodeVideo() {
        if (this.mObserver != null) {
            return this.mObserver.insertHardDecodedData();
        }
        return null;
    }

    public void release() {
        this.mObserver = null;
    }

    public static interface LiveCallback {
        public void notifyEvent(int var1, String var2);

        public void notifyVideoData(byte[] var1, int var2, int var3);

        public int notifyAudioData(byte[] var1, int var2);

        public void onHardDecodeVideoData(byte[] var1, int var2, int var3, int var4, long var5);

        public VideoInfo insertHardDecodedData();
    }
}

