/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautify;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import com.faceunity.core.callback.OperateCallback;
import com.faceunity.core.entity.FURenderInputData;
import com.faceunity.core.entity.FURenderOutputData;
import com.faceunity.core.enumeration.CameraFacingEnum;
import com.faceunity.core.enumeration.FUAITypeEnum;
import com.faceunity.core.enumeration.FUExternalInputEnum;
import com.faceunity.core.enumeration.FUInputBufferEnum;
import com.faceunity.core.enumeration.FUInputTextureEnum;
import com.faceunity.core.enumeration.FUTransformMatrixEnum;
import com.faceunity.core.faceunity.FUAIKit;
import com.faceunity.core.faceunity.FURenderKit;
import com.faceunity.core.faceunity.FURenderManager;
import com.faceunity.core.model.facebeauty.FaceBeauty;
import com.faceunity.core.utils.FULogger;
import com.faceunity.wrapper.faceunity;
import com.vhall.beautify.AuthUtil;
import com.vhall.beautify.DefaultFaceBeautyDataFactory;
import com.vhall.beautify.DemoConfig;
import com.vhall.beautify.FuDeviceUtils;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.IVHBeautifyService;
import com.vhall.beautify.ParamMappingHelper;
import com.vhall.beautify.VHBeautifyKit;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class VHBeautifyImpl
implements IVHBeautifyService {
    private static final String TAG = "VH_BeautifyImpl";
    private FUExternalInputEnum externalInputType = FUExternalInputEnum.EXTERNAL_INPUT_TYPE_CAMERA;
    private FUInputTextureEnum inputTextureType = FUInputTextureEnum.FU_ADM_FLAG_COMMON_TEXTURE;
    private FUInputBufferEnum inputBufferType = FUInputBufferEnum.FU_FORMAT_NV21_BUFFER;
    private final FURenderKit mFURenderKit = FURenderKit.getInstance();
    private final FUAIKit mFUAIKit = FUAIKit.getInstance();
    private static final String ERRMSG_AUTH_NULL = "SDK\u6388\u6743\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
    private DefaultFaceBeautyDataFactory faceBeautyDataFactory;
    private SensorManager mSensorManager = null;
    private Sensor mSensor = null;
    private WeakReference<Context> mWeakContext = null;
    private int mDeviceOrientation = 90;
    private boolean renderOfRTC = false;
    private final int DEFAULT_INPUTORIENTATION = 0;
    private int mInputOrientation = 0;
    private int mActivityOrientation = 1;
    private int mCameraFacing = 1;
    private static boolean mRegisterSucceeded = false;
    private int openCameraIgnoreFrame = 0;
    private float[] TEXTURE_MATRIX_CCRO_FLIPV_0 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private float[] TEXTURE_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    protected volatile FURenderInputData currentFURenderInputData = new FURenderInputData(0, 0);
    private final Object mFURenderInputDataLock = new Object();
    private float[] defaultFUTexMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private float[] defaultFUMvpMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private float[] currentFUTexMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private float[] currentFUMvpMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private float[] originTexMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private float[] originMvpMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private float[] smallViewMatrix = Arrays.copyOf(this.TEXTURE_MATRIX, this.TEXTURE_MATRIX.length);
    private final SensorEventListener mSensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                float x = event.values[0];
                float y = event.values[1];
                if (Math.abs(x) > 3.0f || Math.abs(y) > 3.0f) {
                    if (Math.abs(x) > Math.abs(y)) {
                        VHBeautifyImpl.this.mDeviceOrientation = x > 0.0f ? 0 : 180;
                    } else {
                        VHBeautifyImpl.this.mDeviceOrientation = y > 0.0f ? 90 : 270;
                    }
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public void init(Context context, IVHBeautifyInitListener ivhBeautifyInitListener) {
        Bundle config = new Bundle();
        config.putByteArray("auth", new AuthUtil().byteArray());
        this.init(context, config, ivhBeautifyInitListener);
    }

    private void init(Context context, Bundle config, final IVHBeautifyInitListener initListener) {
        Log.d((String)TAG, (String)">>>init FU beautify");
        byte[] auth = config.getByteArray("auth");
        if (null == auth) {
            Log.d((String)TAG, (String)ERRMSG_AUTH_NULL);
            if (null != initListener) {
                initListener.onError(303, ERRMSG_AUTH_NULL);
            }
            return;
        }
        this.mWeakContext = new WeakReference<Context>(context.getApplicationContext());
        FURenderManager.setKitDebug((FULogger.LogLevel)FULogger.LogLevel.ERROR);
        FURenderManager.setCoreDebug((FULogger.LogLevel)FULogger.LogLevel.INFO);
        FURenderManager.registerFURender((Context)context, (byte[])auth, (OperateCallback)new OperateCallback(){

            public void onSuccess(int code, @NotNull String msg) {
                Log.d((String)VHBeautifyImpl.TAG, (String)("success: " + code + " - " + msg));
                mRegisterSucceeded = true;
                if (null != initListener) {
                    initListener.onSuccess();
                }
            }

            public void onFail(int errCode, @NotNull String msg) {
                int vhErrCode = ParamMappingHelper.mappingCode(errCode);
                Log.d((String)VHBeautifyImpl.TAG, (String)("vhErrCode: " + vhErrCode + "    thirdErrCode: " + errCode + "   msg: " + msg));
                mRegisterSucceeded = false;
                if (null != initListener) {
                    initListener.onError(vhErrCode, msg);
                }
            }
        });
    }

    private DefaultFaceBeautyDataFactory beautyDataFactory() {
        if (null == this.faceBeautyDataFactory) {
            this.faceBeautyDataFactory = new DefaultFaceBeautyDataFactory();
        }
        return this.faceBeautyDataFactory;
    }

    private void bindFaceBeautySource(FaceBeauty faceBeauty) {
        if (mRegisterSucceeded) {
            try {
                this.getSensorManager().registerListener(this.mSensorEventListener, this.getSensor(), 3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                FURenderKit.getInstance().setFaceBeauty(faceBeauty);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.loadFaceProcessor();
        }
    }

    public int renderWithTexture(int width, int height, int texture) {
        FURenderInputData inputData = new FURenderInputData(width, height);
        inputData.setTexture(new FURenderInputData.FUTexture(this.inputTextureType, texture));
        FURenderInputData.FURenderConfig fuRenderConfig = inputData.getRenderConfig();
        fuRenderConfig.setExternalInputType(FUExternalInputEnum.EXTERNAL_INPUT_TYPE_CAMERA);
        this.calculateInputOrientation();
        fuRenderConfig.setInputOrientation(this.mInputOrientation);
        this.resetInputOrientation();
        fuRenderConfig.setDeviceOrientation(this.mDeviceOrientation);
        fuRenderConfig.setInputTextureMatrix(FUTransformMatrixEnum.CCROT0);
        fuRenderConfig.setCameraFacing(this.mCameraFacing == 1 ? CameraFacingEnum.CAMERA_FRONT : CameraFacingEnum.CAMERA_BACK);
        fuRenderConfig.setOutputMatrix(FUTransformMatrixEnum.CCROT0_FLIPVERTICAL);
        this.renderBefore(inputData);
        FURenderOutputData outputData = this.mFURenderKit.renderWithInput(inputData);
        this.renderAfter();
        if (null != outputData && null != outputData.getTexture() && 0 < outputData.getTexture().getTexId()) {
            return outputData.getTexture().getTexId();
        }
        faceunity.fuGetSystemError();
        Log.e((String)TAG, (String)"faceunity\u5f02\u5e38--->[faceunity.fuGetSystemError()]\uff0c\u8bf7\u68c0\u67e5\u63a7\u5236\u53f0\u8f93\u51fa");
        return texture;
    }

    private void calculateInputOrientation() {
        if (this.renderOfRTC) {
            this.mInputOrientation = this.mCameraFacing == 0 ? 90 : 270;
        } else if (this.mCameraFacing == 0) {
            this.mInputOrientation = this.mDeviceOrientation == 0 | this.mDeviceOrientation == 180 ? (this.isActvityPortrait() ? 180 : 270) : (this.isActvityPortrait() ? 0 : 90);
        } else {
            this.resetInputOrientation();
        }
    }

    private void resetInputOrientation() {
        this.mInputOrientation = this.isActvityPortrait() ? 0 : 90;
    }

    private boolean isActvityPortrait() {
        return this.mActivityOrientation == 1;
    }

    public void setRenderOfRTC(boolean renderOfRTC) {
        this.renderOfRTC = renderOfRTC;
    }

    public String sdkModel() {
        return "model_faceunity";
    }

    public void onCameraSwitch(int cameraFacing) {
        this.mCameraFacing = cameraFacing;
    }

    public void try2Restore() {
        VHBeautifyKit.getInstance().setBeautifyEnable(VHBeautifyKit.getInstance().isBeautifyEnable());
    }

    public void loadFaceProcessor() {
        try {
            FUAIKit.getInstance().loadAIProcessor(DemoConfig.BUNDLE_AI_FACE, FUAITypeEnum.FUAITYPE_FACEPROCESSOR);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void judgeDeviceLevel(WeakReference<Context> activityWeakReference) {
        if (null != activityWeakReference && null != activityWeakReference.get()) {
            DemoConfig.DEVICE_LEVEL = FuDeviceUtils.judgeDeviceLevel((Context)activityWeakReference.get());
        }
    }

    public void setFilterIntensity(double filterIntensity) {
        if (this.checkFURenderKit()) {
            this.mFURenderKit.getFaceBeauty().setFilterIntensity(filterIntensity);
        }
    }

    public void setFilter(String filterName, double filterIntensity) {
        if (this.checkFURenderKit()) {
            this.mFURenderKit.getFaceBeauty().setFilterName(ParamMappingHelper.mapping(filterName));
            this.mFURenderKit.getFaceBeauty().setFilterIntensity(filterIntensity);
        }
    }

    public void updateParamIntensity(String key, double value) {
        if (key.startsWith("vh_")) {
            this.beautyDataFactory().updateParamIntensity(ParamMappingHelper.mapping(key), value);
        } else {
            this.beautyDataFactory().updateParamIntensity(key, value);
        }
    }

    public double getParamIntensity(String key) {
        return this.beautyDataFactory().getParamIntensity(key);
    }

    public void onBeautifyEnable(boolean enable) {
        if (enable) {
            this.bindFaceBeautySource(this.currentFaceBeauty());
        }
    }

    public void setActivityOrientation(int activityOrientation) {
        this.mActivityOrientation = activityOrientation;
    }

    private FaceBeauty currentFaceBeauty() {
        FaceBeauty faceBeauty = FURenderKit.getInstance().getFaceBeauty();
        return null == faceBeauty ? DefaultFaceBeautyDataFactory.defaultFaceBeauty : faceBeauty;
    }

    public void release() {
        this.renderOfRTC = false;
        if (null != this.mFURenderKit) {
            this.mFURenderKit.release();
        }
        if (null != this.mFUAIKit) {
            this.mFUAIKit.releaseAllAIProcessor();
        }
        if (null != this.mSensorManager) {
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
        }
    }

    private boolean checkFURenderKit() {
        boolean isFURenderKitEnable;
        boolean bl = isFURenderKitEnable = null != this.mFURenderKit && null != this.mFURenderKit.getFaceBeauty();
        if (!isFURenderKitEnable) {
            Log.e((String)TAG, (String)">>>FURenderKit is null");
        }
        return isFURenderKitEnable;
    }

    private void renderBefore(FURenderInputData inputData) {
        this.checkSpecialDevice(inputData);
        if (DemoConfig.DEVICE_LEVEL > 1) {
            this.cheekFaceNum();
        }
        inputData.setImageBuffer(null);
    }

    private void renderAfter() {
        if (null != VHBeautifyKit.getInstance().getFaceDetectionListener() && VHBeautifyKit.getInstance().isFaceDetectionEnable()) {
            VHBeautifyKit.getInstance().getFaceDetectionListener().onFaceDetection(this.mFUAIKit.isTracking());
        }
    }

    private void cheekFaceNum() {
        float faceProcessorGetConfidenceScore = this.mFUAIKit.getFaceProcessorGetConfidenceScore(0);
        if ((double)faceProcessorGetConfidenceScore >= 0.95) {
            if (this.mFURenderKit != null && this.mFURenderKit.getFaceBeauty() != null && this.mFURenderKit.getFaceBeauty().getBlurType() != 3) {
                this.mFURenderKit.getFaceBeauty().setBlurType(3);
                this.mFURenderKit.getFaceBeauty().setEnableBlurUseMask(true);
            }
        } else if (this.mFURenderKit != null && this.mFURenderKit.getFaceBeauty() != null && this.mFURenderKit.getFaceBeauty().getBlurType() != 2) {
            this.mFURenderKit.getFaceBeauty().setBlurType(2);
            this.mFURenderKit.getFaceBeauty().setEnableBlurUseMask(false);
        }
    }

    private void checkSpecialDevice(FURenderInputData inputData) {
        if (FuDeviceUtils.isNexus6P() && inputData.getRenderConfig().getCameraFacing() == CameraFacingEnum.CAMERA_FRONT) {
            inputData.getRenderConfig().setInputTextureMatrix(FUTransformMatrixEnum.CCROT90_FLIPVERTICAL);
            inputData.getRenderConfig().setInputBufferMatrix(FUTransformMatrixEnum.CCROT90_FLIPVERTICAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FURenderInputData buildFURenderInputData() {
        Object object = this.mFURenderInputDataLock;
        synchronized (object) {
            this.currentFURenderInputData.clone();
            if (this.openCameraIgnoreFrame > 0) {
                --this.openCameraIgnoreFrame;
                this.currentFURenderInputData.setImageBuffer(null);
                this.currentFURenderInputData.setTexture(null);
            }
            return this.currentFURenderInputData;
        }
    }

    private SensorManager getSensorManager() {
        if (null == this.mSensorManager && null != this.mWeakContext) {
            this.mSensorManager = (SensorManager)((Context)this.mWeakContext.get()).getSystemService("sensor");
        }
        return this.mSensorManager;
    }

    private Sensor getSensor() {
        if (null == this.mSensor) {
            this.mSensor = this.mSensorManager.getDefaultSensor(1);
        }
        return this.mSensor;
    }
}

