/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.logmanager;

import android.text.TextUtils;
import android.util.Log;
import com.vhall.logmanager.VHLogFileManager;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class VLog {
    private static final String TAG_PREFIX = "vh_";
    private static LogLevel mLogLevel = LogLevel.ERROR;
    private static boolean mEnableSDCache = false;

    public static void setLogLevel(LogLevel logLevel) {
        mLogLevel = logLevel;
    }

    public static void enableSDCache(boolean enable) {
        mEnableSDCache = enable;
    }

    public static void v(String tag, String message) {
        if (VLog.compare(mLogLevel, LogLevel.VERBOSE) && VLog.checkParam(message)) {
            Log.v((String)VLog.makeTag(tag), (String)message);
            VLog.write2File(null, tag, message);
        }
    }

    public static void i(String tag, String message) {
        if (VLog.compare(mLogLevel, LogLevel.VERBOSE) && VLog.checkParam(message)) {
            Log.i((String)VLog.makeTag(tag), (String)message);
            VLog.write2File(null, tag, message);
        }
    }

    public static void d(String tag, String message) {
        if (VLog.compare(mLogLevel, LogLevel.DEBUG) && VLog.checkParam(message)) {
            Log.d((String)VLog.makeTag(tag), (String)message);
            VLog.write2File(null, tag, message);
        }
    }

    public static void d(String path, String tag, String message) {
        if (VLog.compare(mLogLevel, LogLevel.DEBUG) && VLog.checkParam(message)) {
            Log.d((String)VLog.makeTag(tag), (String)message);
            VLog.write2File(path, tag, message);
        }
    }

    public static void w(String tag, String message) {
        if (VLog.compare(mLogLevel, LogLevel.ERROR) && VLog.checkParam(message)) {
            Log.w((String)VLog.makeTag(tag), (String)message);
            VLog.write2File(null, tag, message);
        }
    }

    public static void e(String tag, String message) {
        if (VLog.compare(mLogLevel, LogLevel.ERROR) && VLog.checkParam(message)) {
            Log.e((String)VLog.makeTag(tag), (String)message);
            VLog.write2File(null, tag, message);
        }
    }

    private static void write2File(String path, String tag, String message) {
        if (mEnableSDCache) {
            String formattedMsg = String.format("%s -> %s ---> %s%s", VLog.getTime(), tag, message, "\n");
            VHLogFileManager.writeToStorage(path, formattedMsg);
        }
    }

    private static String getTime() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private static boolean checkParam(String message) {
        return !TextUtils.isEmpty((CharSequence)message);
    }

    private static String makeTag(String oriTag) {
        return TAG_PREFIX.concat(oriTag);
    }

    private static boolean compare(LogLevel curValue, LogLevel targetValue) {
        return curValue.ordinal() >= targetValue.ordinal();
    }

    public static enum LogLevel {
        NONE,
        ERROR,
        DEBUG,
        VERBOSE;

    }
}

