/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.logmanager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.vhall.logmanager.VhallDeviceId;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class LogTool {
    @SuppressLint(value={"MissingPermission"})
    public static String getIMEI(Context context) {
        return VhallDeviceId.getVhallDeviceId(context);
    }

    public static String getVersion(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getNetworkType(Context context) {
        String network = null;
        if (context != null) {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isAvailable()) {
                return network;
            }
            int nType = networkInfo.getType();
            if (nType == 1) {
                network = "WIFI";
            } else if (nType == 0) {
                int nSubType = networkInfo.getSubtype();
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                network = nSubType == 13 && !telephonyManager.isNetworkRoaming() ? "4G" : (nSubType == 3 || nSubType == 8 || nSubType == 5 && !telephonyManager.isNetworkRoaming() ? "3G" : (nSubType == 1 || nSubType == 2 || nSubType == 4 && !telephonyManager.isNetworkRoaming() ? "2G" : "2G"));
            }
            return network;
        }
        return network;
    }

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static String getAppVersionName(Context context) {
        String verName = "Unkonw";
        try {
            verName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return verName;
    }

    public static String getSignatureSHA1(Context context) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        int flags = 64;
        PackageInfo packageInfo = null;
        try {
            packageInfo = pm.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Signature[] signatures = packageInfo.signatures;
        byte[] cert = signatures[0].toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(cert);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        X509Certificate c = null;
        try {
            c = (X509Certificate)cf.generateCertificate(input);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        Object hexString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(c.getEncoded());
            return LogTool.byte2HexFormatted(publicKey);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
            if (i >= arr.length - 1) continue;
            str.append(':');
        }
        return str.toString();
    }
}

