/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.logmanager;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.vhall.httpclient.utils.OKHttpUtils;
import com.vhall.logmanager.IReportCallbcak;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogTool;
import com.vhall.logmanager.VLog;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public final class LogReporter {
    public static final String TAG = LogReporter.class.getName();
    public static final int UNIT_CLASS = 2;
    public static final int UNIT_PAAS = 1;
    public static final int UNIT_SAAS = 0;
    public static final int PLANTFORM_APP = 1;
    public static final int PLANTFORM_SDK = 5;
    public static final int PLANTFORM_UNDEFINED = -1;
    public static final String HOST = "https://pingback.e.vhall.com/msdk.gif";
    public static final String LOG_EVENT_INITSDK = "2001";
    public static final String LOG_EVENT_INITLSS_PUSH = "2002";
    public static final String LOG_EVENT_INITLSS_WATCH = "2003";
    public static final String LOG_EVENT_INITVOD = "2004";
    public static final String LOG_EVENT_INITOPS = "2005";
    public static final String LOG_EVENT_INITIM = "2006";
    public static final String LOG_EVENT_INITILSS = "2007";
    public static final String LOG_EVENT_SETUSERID = "2008";
    public static final String LOG_EVENT_CREATE = "2009";
    public static final String LOG_EVENT_INITLSS_TIMESHIFT = "2010";
    public static final String LOG_ERROR_NET = "-1";
    public static final String LOG_ERROR_EXCEPTION = "-2";
    public static final String hostFormat = "%s?k=%s&id=%s&s=%s&bu=%d&token=%s";
    public static final String hostFormatWithoutS = "%s?k=%s&id=%s&bu=%d&token=%s";
    public static final String hostFormatWithBigData = "%s?app_id=%s&data=%s&send_type=img";
    public static final String LOG_REPORT_LSS_MUTE_VIDEO = "113101";
    public static final String LOG_REPORT_LSS_MUTE_AUDIO = "113102";
    public static final String LOG_REPORT_LSS_FIRST_FRAME = "113103";
    public static final String LOG_REPORT_SCREENSHARE = "113104";
    public static final String LOG_REPORT_MCORE_PUSH = "113105";
    public static final String LOG_REPORT_MCORE_EVENT = "113106";
    public static final String LOG_REPORT_MCORE_STOP = "113107";
    public static final String LOG_REPORT_MSG_CONNECT = "113500";
    public static final String LOG_REPORT_MSG_STATUS = "113501";
    public static final String LOG_REPORT_MSG_DISCONNECT = "113502";
    public static final String LOG_REPORT_RTC_CONNECT = "113300";
    public static final String LOG_REPORT_RTC_DISCONNECT = "113301";
    public static final String LOG_REPORT_RTC_MUTE_VIDEO = "113302";
    public static final String LOG_REPORT_RTC_MUTE_AUDIO = "113303";
    public static final String LOG_REPORT_RTC_FIRST_FRAME = "113304";
    public static final String LOG_REPORT_RTC_BROADCAST = "113305";
    public static final String LOG_REPORT_RTC_MAINSCREEN = "113306";
    public static final String LOG_REPORT_RTC_BROADCAST_BG_IMAGE = "113307";
    public static final String LOG_REPORT_RTC_SUBSCRIBE = "113308";
    public static final String LOG_REPORT_VOD_INIT = "113700";
    public static final String LOG_REPORT_VOD_STATUS = "113702";
    public static final String LOG_REPORT_VOD_SEEK = "113703";
    private String mHost = "https://pingback.e.vhall.com/msdk.gif";
    private String mPhone;
    private String mVersion;
    private int mBu = 1;
    private String mAppId;
    private String mUserId;
    private String mOS;
    private String mCN;
    private String mIMEI;
    private String mPackageName;
    private String mAppVersionName;
    private int mPlantform = -1;
    private String mError;
    private String keyHead = "28";
    private static OkHttpClient okHttpClient;
    private String extraInfo;
    private IReportCallbcak mReportCallback;
    private static LogReporter mInstance;

    public void setUserid(String userid) {
        this.mUserId = userid;
    }

    public void setJoinid(String joinId) {
        LogInfo.getInstance().setJoinId(joinId);
    }

    public void setErr(String err) {
        this.mError = err;
    }

    @Deprecated
    public void setDebug(boolean debug) {
    }

    public void setReportRawCallback(IReportCallbcak reportRawCallback) {
        this.mReportCallback = reportRawCallback;
    }

    public static LogReporter getInstance() {
        if (mInstance == null) {
            mInstance = new LogReporter();
            okHttpClient = OKHttpUtils.createOkClient();
        }
        return mInstance;
    }

    public void init(Context context, String host, String version, int bu, String appId, String uid) {
        this.init(context, host, version, bu, appId, uid, 5);
    }

    public void init(Context context, String host, String version, int bu, String appId, String uid, int platform) {
        if (!TextUtils.isEmpty((CharSequence)host)) {
            this.mHost = host;
        }
        this.mVersion = version;
        if (this.mPlantform == -1) {
            this.mPlantform = platform;
        }
        this.mBu = bu;
        this.assembleBUKeyHead(bu);
        this.mAppId = appId;
        this.mUserId = uid;
        this.mPhone = Build.MANUFACTURER + Build.MODEL;
        this.mOS = "android " + LogTool.getSystemVersion();
        this.mCN = LogTool.getNetworkType(context);
        this.mIMEI = LogTool.getIMEI(context);
        this.mPackageName = LogTool.getPackageName(context);
        this.mAppVersionName = LogTool.getAppVersionName(context);
    }

    public void setPlatform(int platform) {
        this.mPlantform = platform;
    }

    public void initExtra(Bundle extra) {
        if (extra != null) {
            this.extraInfo = extra.getString("extra");
        }
    }

    private void assembleBUKeyHead(int bu) {
        switch (bu) {
            case 0: {
                this.keyHead = "29";
                break;
            }
            case 1: {
                this.keyHead = "28";
                break;
            }
            case 2: {
                this.keyHead = "50";
            }
        }
    }

    private String toJsonString(boolean isSuccess, JSONObject collectionParam, long timestampOfSecond) throws JSONException {
        if (collectionParam == null) {
            collectionParam = new JSONObject();
        }
        collectionParam.put("cv", (Object)this.mVersion);
        collectionParam.put("dt", (Object)this.mPhone);
        collectionParam.put("os", (Object)this.mOS);
        collectionParam.put("cn", (Object)this.mCN);
        collectionParam.put("imei", (Object)this.mIMEI);
        collectionParam.put("uu", (Object)this.mIMEI);
        collectionParam.put("bid", (Object)this.mPackageName);
        collectionParam.put("pf", this.mPlantform);
        collectionParam.put("av", (Object)this.mAppVersionName);
        collectionParam.put("app_id", (Object)this.mAppId);
        collectionParam.put("log_v", (Object)"2.7.1");
        collectionParam.put("ct", timestampOfSecond);
        collectionParam.put("extra", (Object)this.extraInfo);
        if (!collectionParam.has("uid") || TextUtils.isEmpty((CharSequence)collectionParam.optString("uid"))) {
            collectionParam.put("uid", (Object)LogInfo.getInstance().getUid());
        }
        if (!isSuccess) {
            collectionParam.put("err", (Object)this.mError);
        }
        String collectionStr = collectionParam.toString();
        return new String(Base64.encode((byte[])collectionStr.getBytes(), (int)2));
    }

    private void doOnCollection(String host, long timestamp, String k, boolean useKeyHead, String sessionId, boolean isSuccess, JSONObject jsonObject) {
        try {
            if (useKeyHead && !LOG_ERROR_NET.equals(k) && !LOG_ERROR_EXCEPTION.equals(k)) {
                k = this.keyHead + k;
            }
            if (TextUtils.isEmpty((CharSequence)sessionId)) {
                sessionId = LogInfo.getInstance().getSession_id();
            }
            this.report(host, k, sessionId, this.toJsonString(isSuccess, jsonObject, timestamp), timestamp);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onCollection(String host, long timestamp, String k, String sessionId, boolean isSuccess, JSONObject jsonObject) {
        this.doOnCollection(host, timestamp, k, true, sessionId, isSuccess, jsonObject);
    }

    public void onCollection(String k, String sessionId, boolean isSuccess, JSONObject jsonObject) {
        this.onCollection(null, System.currentTimeMillis(), k, sessionId, isSuccess, jsonObject);
    }

    public void onCollection(String k, boolean isSuccess, JSONObject jsonObject) {
        this.onCollection(k, null, isSuccess, jsonObject);
    }

    public void onCollection(String k, JSONObject jsonObject) {
        this.onCollection(k, null, true, jsonObject);
    }

    public void onCollectionWithBData(String k, JSONObject jsonObject) {
        String host = LogInfo.getInstance().getHost();
        if (!TextUtils.isEmpty((CharSequence)host)) {
            this.onCollection(host, System.currentTimeMillis(), k, false, jsonObject);
        }
    }

    public void onCollection(String host, String k, JSONObject jsonObject) {
        this.onCollection(host, System.currentTimeMillis(), k, null, true, jsonObject);
    }

    public void onCollection(String host, long timestamp, String k, boolean useKeyHead, JSONObject jsonObject) {
        this.doOnCollection(host, timestamp, k, useKeyHead, null, true, jsonObject);
    }

    private void report(String host, String k, String sessionId, String token, long timestamp) {
        String realHost = null == host ? this.mHost : host;
        String reportHost = TextUtils.isEmpty((CharSequence)sessionId) ? String.format(hostFormatWithoutS, realHost, k, "Android" + timestamp, this.mBu, token) : String.format(hostFormat, realHost, k, "Android" + timestamp, sessionId, this.mBu, token);
        VLog.d(TAG, "---> " + reportHost);
        Request request = new Request.Builder().url(reportHost).get().build();
        if (okHttpClient != null) {
            okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    VLog.d(TAG, "------> " + (null != e ? e.toString() : "exception is null"));
                    if (null != LogReporter.this.mReportCallback) {
                        LogReporter.this.mReportCallback.onComplete(false);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    VLog.d(TAG, "------> " + (null != response && null != response.body() ? response.body().string() : "response is null"));
                    if (200 == response.code()) {
                        if (null != LogReporter.this.mReportCallback) {
                            LogReporter.this.mReportCallback.onComplete(true);
                        }
                    } else if (null != LogReporter.this.mReportCallback) {
                        LogReporter.this.mReportCallback.onComplete(false);
                    }
                }
            });
        }
    }

    public void reportToDataHub(String host, String app_id, JSONObject jsonObject, long timestamp, boolean isSuccess) {
        try {
            this.report(host, app_id, this.toJsonString(isSuccess, jsonObject, timestamp));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void report(String host, String app_id, String data) {
        String realHost = null == host ? this.mHost : host;
        String reportHost = String.format(hostFormatWithBigData, realHost, app_id, data);
        String str = String.format(hostFormatWithBigData, "/up", app_id, data);
        byte[] md5str = LogReporter.md5(str).getBytes();
        reportHost = reportHost + "&validkey=" + md5str[2] + md5str[0] + md5str[4];
        VLog.d(TAG, "---> " + reportHost);
        Request request = new Request.Builder().url(reportHost).get().build();
        if (okHttpClient != null) {
            okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    VLog.d(TAG, "------> " + (null != e ? e.toString() : "exception is null"));
                    if (null != LogReporter.this.mReportCallback) {
                        LogReporter.this.mReportCallback.onComplete(false);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    VLog.d(TAG, "------> " + (null != response && null != response.body() ? response.body().string() : "response is null"));
                    if (200 == response.code()) {
                        if (null != LogReporter.this.mReportCallback) {
                            LogReporter.this.mReportCallback.onComplete(true);
                        }
                    } else if (null != LogReporter.this.mReportCallback) {
                        LogReporter.this.mReportCallback.onComplete(false);
                    }
                }
            });
        }
    }

    public static String md5(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result = result + temp;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

