/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.impl.builder;

import com.vhall.httpclient.core.IVHNetLogCallback;
import com.vhall.httpclient.core.IVHNetRequestConfig;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class PostFormBuilder {
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private int mConnectTimeOut = 60000;
    private int mReadTimeOut = 60000;
    private int mWriteTimeOut = 60000;
    private Proxy mProxy;
    private IVHNetLogCallback mLogCallback = new IVHNetLogCallback(){

        @Override
        public void log(String url, String message) {
        }
    };
    private String mMethod = IVHNetRequestConfig.Method.POST.name();
    private String mContentType = "application/x-www-form-urlencoded";
    private String mCharset = "UTF_8";
    private String mAccept = "application/json";
    private SSLSocketFactory mSslSocketFactory = null;
    private X509TrustManager mTrustManager = null;
    private HostnameVerifier mHostnameVerifier = null;

    public PostFormBuilder addHeader(String name, String value) {
        this.mHeaders.put(name, value);
        return this;
    }

    public PostFormBuilder addCookies(String name, String value) {
        return this;
    }

    public PostFormBuilder setConnectTimeOut(int timeOut) {
        this.mConnectTimeOut = timeOut;
        return this;
    }

    public PostFormBuilder setReadTimeOut(int timeOut) {
        this.mReadTimeOut = timeOut;
        return this;
    }

    public PostFormBuilder setWriteTimeOut(int timeOut) {
        this.mWriteTimeOut = timeOut;
        return this;
    }

    public PostFormBuilder setProxy(Proxy proxy) {
        this.mProxy = proxy;
        return this;
    }

    public PostFormBuilder setLogReporter(IVHNetLogCallback callback) {
        this.mLogCallback = callback;
        return this;
    }

    public PostFormBuilder setCharset(String charset) {
        this.mCharset = charset;
        return this;
    }

    public PostFormBuilder setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.mSslSocketFactory = sslSocketFactory;
        return this;
    }

    public PostFormBuilder setTrustManager(X509TrustManager trustManager) {
        this.mTrustManager = trustManager;
        return this;
    }

    public PostFormBuilder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.mHostnameVerifier = hostnameVerifier;
        return this;
    }

    public IVHNetRequestConfig build() {
        return new IVHNetRequestConfig(){

            @Override
            public String getContentType() {
                return PostFormBuilder.this.mContentType;
            }

            @Override
            public String getCharset() {
                return PostFormBuilder.this.mCharset;
            }

            @Override
            public String getAccept() {
                return PostFormBuilder.this.mAccept;
            }

            @Override
            public Map<String, String> getHeaders() {
                return PostFormBuilder.this.mHeaders;
            }

            @Override
            public Map<String, String> getCookies() {
                return null;
            }

            @Override
            public int getConnectTimeOut() {
                return PostFormBuilder.this.mConnectTimeOut;
            }

            @Override
            public int getReadTimeOut() {
                return PostFormBuilder.this.mReadTimeOut;
            }

            @Override
            public int getWriteTimeOut() {
                return PostFormBuilder.this.mWriteTimeOut;
            }

            @Override
            public Proxy getProxy() {
                return PostFormBuilder.this.mProxy;
            }

            @Override
            public HostnameVerifier getHostnameVerifier() {
                return PostFormBuilder.this.mHostnameVerifier;
            }

            @Override
            public IVHNetLogCallback getLogReporter() {
                return PostFormBuilder.this.mLogCallback;
            }

            @Override
            public String getMethod() {
                return PostFormBuilder.this.mMethod;
            }

            @Override
            public SSLSocketFactory getSslSocketFactory() {
                return PostFormBuilder.this.mSslSocketFactory;
            }

            @Override
            public X509TrustManager getTrustManager() {
                return PostFormBuilder.this.mTrustManager;
            }
        };
    }
}

