/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.core;

import com.vhall.httpclient.core.IVHNetRequestConfig;
import com.vhall.httpclient.impl.VHHttpConnection;
import com.vhall.httpclient.impl.VHHttpsConnection;
import java.net.HttpURLConnection;

public abstract class BaseHttpConnection {
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "Charset";
    public static final String ACCEPT = "accept";
    private String url;
    private IVHNetRequestConfig config;

    public abstract HttpURLConnection getHttpConnection();

    public BaseHttpConnection(String url, IVHNetRequestConfig config) {
        this.url = url;
        this.config = config;
    }

    public static BaseHttpConnection selectConnection(String url, IVHNetRequestConfig config) {
        if (url.startsWith("https:")) {
            return new VHHttpsConnection(url, config);
        }
        if (url.startsWith("http:")) {
            return new VHHttpConnection(url, config);
        }
        return new VHHttpsConnection(url, config);
    }

    protected void printLog(String message) {
        this.config.getLogReporter().log(this.url, message);
    }
}

