/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.ui.spherical;

import android.annotation.TargetApi;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.text.TextUtils;
import com.vhall.android.exoplayer2.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

final class GlUtil {
    private static final String TAG = "Spherical.Utils";

    private GlUtil() {
    }

    public static void checkGlError() {
        int error = GLES20.glGetError();
        if (error != 0) {
            do {
                int lastError = error;
                Log.e((String)TAG, (String)("glError " + GLU.gluErrorString((int)lastError)));
            } while ((error = GLES20.glGetError()) != 0);
        }
    }

    public static int compileProgram(String[] vertexCode, String[] fragmentCode) {
        GlUtil.checkGlError();
        int vertexShader = GLES20.glCreateShader((int)35633);
        GLES20.glShaderSource((int)vertexShader, (String)TextUtils.join((CharSequence)"\n", (Object[])vertexCode));
        GLES20.glCompileShader((int)vertexShader);
        GlUtil.checkGlError();
        int fragmentShader = GLES20.glCreateShader((int)35632);
        GLES20.glShaderSource((int)fragmentShader, (String)TextUtils.join((CharSequence)"\n", (Object[])fragmentCode));
        GLES20.glCompileShader((int)fragmentShader);
        GlUtil.checkGlError();
        int program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GLES20.glAttachShader((int)program, (int)fragmentShader);
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            String errorMsg = "Unable to link shader program: \n" + GLES20.glGetProgramInfoLog((int)program);
            Log.e((String)TAG, (String)errorMsg);
        }
        GlUtil.checkGlError();
        return program;
    }

    public static FloatBuffer createBuffer(float[] data) {
        ByteBuffer bb = ByteBuffer.allocateDirect(data.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer buffer = bb.asFloatBuffer();
        buffer.put(data);
        buffer.position(0);
        return buffer;
    }

    @TargetApi(value=15)
    public static int createExternalTexture() {
        int[] texId = new int[1];
        GLES20.glGenTextures((int)1, (IntBuffer)IntBuffer.wrap(texId));
        GLES20.glBindTexture((int)36197, (int)texId[0]);
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError();
        return texId[0];
    }
}

