/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.dash.offline;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.vhall.android.exoplayer2.Format;
import com.vhall.android.exoplayer2.offline.DownloadHelper;
import com.vhall.android.exoplayer2.offline.StreamKey;
import com.vhall.android.exoplayer2.offline.TrackKey;
import com.vhall.android.exoplayer2.source.TrackGroup;
import com.vhall.android.exoplayer2.source.TrackGroupArray;
import com.vhall.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.vhall.android.exoplayer2.source.dash.manifest.DashManifest;
import com.vhall.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.vhall.android.exoplayer2.source.dash.manifest.Representation;
import com.vhall.android.exoplayer2.source.dash.offline.DashDownloadAction;
import com.vhall.android.exoplayer2.upstream.DataSource;
import com.vhall.android.exoplayer2.upstream.ParsingLoadable;
import com.vhall.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DashDownloadHelper
extends DownloadHelper {
    private final Uri uri;
    private final DataSource.Factory manifestDataSourceFactory;
    private @MonotonicNonNull DashManifest manifest;

    public DashDownloadHelper(Uri uri, DataSource.Factory manifestDataSourceFactory) {
        this.uri = uri;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
    }

    protected void prepareInternal() throws IOException {
        DataSource dataSource = this.manifestDataSourceFactory.createDataSource();
        this.manifest = (DashManifest)ParsingLoadable.load((DataSource)dataSource, (ParsingLoadable.Parser)new DashManifestParser(), (Uri)this.uri, (int)4);
    }

    public DashManifest getManifest() {
        Assertions.checkNotNull((Object)this.manifest);
        return this.manifest;
    }

    public int getPeriodCount() {
        Assertions.checkNotNull((Object)this.manifest);
        return this.manifest.getPeriodCount();
    }

    public TrackGroupArray getTrackGroups(int periodIndex) {
        Assertions.checkNotNull((Object)this.manifest);
        List<AdaptationSet> adaptationSets = this.manifest.getPeriod((int)periodIndex).adaptationSets;
        TrackGroup[] trackGroups = new TrackGroup[adaptationSets.size()];
        for (int i = 0; i < trackGroups.length; ++i) {
            List<Representation> representations = adaptationSets.get((int)i).representations;
            Format[] formats = new Format[representations.size()];
            int representationsCount = representations.size();
            for (int j = 0; j < representationsCount; ++j) {
                formats[j] = representations.get((int)j).format;
            }
            trackGroups[i] = new TrackGroup(formats);
        }
        return new TrackGroupArray(trackGroups);
    }

    public DashDownloadAction getDownloadAction(@Nullable byte[] data, List<TrackKey> trackKeys) {
        return DashDownloadAction.createDownloadAction(this.uri, data, DashDownloadHelper.toStreamKeys(trackKeys));
    }

    public DashDownloadAction getRemoveAction(@Nullable byte[] data) {
        return DashDownloadAction.createRemoveAction(this.uri, data);
    }

    private static List<StreamKey> toStreamKeys(List<TrackKey> trackKeys) {
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>(trackKeys.size());
        for (int i = 0; i < trackKeys.size(); ++i) {
            TrackKey trackKey = trackKeys.get(i);
            streamKeys.add(new StreamKey(trackKey.periodIndex, trackKey.groupIndex, trackKey.trackIndex));
        }
        return streamKeys;
    }
}

