/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import com.vhall.android.exoplayer2.Format;
import com.vhall.android.exoplayer2.source.dash.DashSegmentIndex;
import com.vhall.android.exoplayer2.source.dash.manifest.Descriptor;
import com.vhall.android.exoplayer2.source.dash.manifest.RangedUri;
import com.vhall.android.exoplayer2.source.dash.manifest.SegmentBase;
import com.vhall.android.exoplayer2.source.dash.manifest.SingleSegmentIndex;
import java.util.Collections;
import java.util.List;

public abstract class Representation {
    public static final long REVISION_ID_DEFAULT = -1L;
    public final String contentId;
    public final long revisionId;
    public final Format format;
    public final String baseUrl;
    public final long presentationTimeOffsetUs;
    public final List<Descriptor> inbandEventStreams;
    private final RangedUri initializationUri;

    public static Representation newInstance(String contentId, long revisionId, Format format, String baseUrl, SegmentBase segmentBase) {
        return Representation.newInstance(contentId, revisionId, format, baseUrl, segmentBase, null);
    }

    public static Representation newInstance(String contentId, long revisionId, Format format, String baseUrl, SegmentBase segmentBase, List<Descriptor> inbandEventStreams) {
        return Representation.newInstance(contentId, revisionId, format, baseUrl, segmentBase, inbandEventStreams, null);
    }

    public static Representation newInstance(String contentId, long revisionId, Format format, String baseUrl, SegmentBase segmentBase, List<Descriptor> inbandEventStreams, String customCacheKey) {
        if (segmentBase instanceof SegmentBase.SingleSegmentBase) {
            return new SingleSegmentRepresentation(contentId, revisionId, format, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase, inbandEventStreams, customCacheKey, -1L);
        }
        if (segmentBase instanceof SegmentBase.MultiSegmentBase) {
            return new MultiSegmentRepresentation(contentId, revisionId, format, baseUrl, (SegmentBase.MultiSegmentBase)segmentBase, inbandEventStreams);
        }
        throw new IllegalArgumentException("segmentBase must be of type SingleSegmentBase or MultiSegmentBase");
    }

    private Representation(String contentId, long revisionId, Format format, String baseUrl, SegmentBase segmentBase, List<Descriptor> inbandEventStreams) {
        this.contentId = contentId;
        this.revisionId = revisionId;
        this.format = format;
        this.baseUrl = baseUrl;
        this.inbandEventStreams = inbandEventStreams == null ? Collections.emptyList() : Collections.unmodifiableList(inbandEventStreams);
        this.initializationUri = segmentBase.getInitialization(this);
        this.presentationTimeOffsetUs = segmentBase.getPresentationTimeOffsetUs();
    }

    public RangedUri getInitializationUri() {
        return this.initializationUri;
    }

    public abstract RangedUri getIndexUri();

    public abstract DashSegmentIndex getIndex();

    public abstract String getCacheKey();

    public static class MultiSegmentRepresentation
    extends Representation
    implements DashSegmentIndex {
        private final SegmentBase.MultiSegmentBase segmentBase;

        public MultiSegmentRepresentation(String contentId, long revisionId, Format format, String baseUrl, SegmentBase.MultiSegmentBase segmentBase, List<Descriptor> inbandEventStreams) {
            super(contentId, revisionId, format, baseUrl, segmentBase, inbandEventStreams);
            this.segmentBase = segmentBase;
        }

        @Override
        public RangedUri getIndexUri() {
            return null;
        }

        @Override
        public DashSegmentIndex getIndex() {
            return this;
        }

        @Override
        public String getCacheKey() {
            return null;
        }

        @Override
        public RangedUri getSegmentUrl(long segmentIndex) {
            return this.segmentBase.getSegmentUrl(this, segmentIndex);
        }

        @Override
        public long getSegmentNum(long timeUs, long periodDurationUs) {
            return this.segmentBase.getSegmentNum(timeUs, periodDurationUs);
        }

        @Override
        public long getTimeUs(long segmentIndex) {
            return this.segmentBase.getSegmentTimeUs(segmentIndex);
        }

        @Override
        public long getDurationUs(long segmentIndex, long periodDurationUs) {
            return this.segmentBase.getSegmentDurationUs(segmentIndex, periodDurationUs);
        }

        @Override
        public long getFirstSegmentNum() {
            return this.segmentBase.getFirstSegmentNum();
        }

        @Override
        public int getSegmentCount(long periodDurationUs) {
            return this.segmentBase.getSegmentCount(periodDurationUs);
        }

        @Override
        public boolean isExplicit() {
            return this.segmentBase.isExplicit();
        }
    }

    public static class SingleSegmentRepresentation
    extends Representation {
        public final Uri uri;
        public final long contentLength;
        private final String cacheKey;
        private final RangedUri indexUri;
        private final SingleSegmentIndex segmentIndex;

        public static SingleSegmentRepresentation newInstance(String contentId, long revisionId, Format format, String uri, long initializationStart, long initializationEnd, long indexStart, long indexEnd, List<Descriptor> inbandEventStreams, String customCacheKey, long contentLength) {
            RangedUri rangedUri = new RangedUri(null, initializationStart, initializationEnd - initializationStart + 1L);
            SegmentBase.SingleSegmentBase segmentBase = new SegmentBase.SingleSegmentBase(rangedUri, 1L, 0L, indexStart, indexEnd - indexStart + 1L);
            return new SingleSegmentRepresentation(contentId, revisionId, format, uri, segmentBase, inbandEventStreams, customCacheKey, contentLength);
        }

        public SingleSegmentRepresentation(String contentId, long revisionId, Format format, String baseUrl, SegmentBase.SingleSegmentBase segmentBase, List<Descriptor> inbandEventStreams, String customCacheKey, long contentLength) {
            super(contentId, revisionId, format, baseUrl, segmentBase, inbandEventStreams);
            this.uri = Uri.parse((String)baseUrl);
            this.indexUri = segmentBase.getIndex();
            this.cacheKey = customCacheKey != null ? customCacheKey : (contentId != null ? contentId + "." + format.id + "." + revisionId : null);
            this.contentLength = contentLength;
            this.segmentIndex = this.indexUri != null ? null : new SingleSegmentIndex(new RangedUri(null, 0L, contentLength));
        }

        @Override
        public RangedUri getIndexUri() {
            return this.indexUri;
        }

        @Override
        public DashSegmentIndex getIndex() {
            return this.segmentIndex;
        }

        @Override
        public String getCacheKey() {
            return this.cacheKey;
        }
    }
}

