/*
 * Decompiled with CFR 0.152.
 */
package com.github.vbauer.vfs2.provider.smb;

import com.github.vbauer.vfs2.provider.smb.SmbFileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbRandomAccessFile;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class SmbFileRandomAccessContent
extends AbstractRandomAccessContent {
    public static final char MODE_READ = 'r';
    public static final char MODE_WRITE = 'w';
    private static final String ERROR_OPEN_FAILED = "vfs.provider/random-access-open-failed.error";
    private final SmbRandomAccessFile raf;
    private final InputStream rafis;

    public SmbFileRandomAccessContent(SmbFile smbFile, RandomAccessMode mode) throws FileSystemException {
        super(mode);
        StringBuilder modes = new StringBuilder(2);
        if (mode.requestRead()) {
            modes.append('r');
        }
        if (mode.requestWrite()) {
            modes.append('w');
        }
        try {
            this.raf = new SmbRandomAccessFile(smbFile, modes.toString());
            this.rafis = new SmbFileInputStream(this.raf);
        }
        catch (MalformedURLException | UnknownHostException | SmbException ex) {
            throw new FileSystemException(ERROR_OPEN_FAILED, (Object)smbFile, ex);
        }
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    public void readFully(byte[] b) throws IOException {
        this.raf.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.raf.readFully(b, off, len);
    }

    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }

    public void writeDouble(double v) throws IOException {
        this.raf.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.raf.writeFloat(v);
    }

    public void write(int b) throws IOException {
        this.raf.write(b);
    }

    public void writeByte(int v) throws IOException {
        this.raf.writeByte(v);
    }

    public void writeChar(int v) throws IOException {
        this.raf.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this.raf.writeInt(v);
    }

    public void writeShort(int v) throws IOException {
        this.raf.writeShort(v);
    }

    public void writeLong(long v) throws IOException {
        this.raf.writeLong(v);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.raf.writeBoolean(v);
    }

    public void write(byte[] b) throws IOException {
        this.raf.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    public void writeBytes(String s) throws IOException {
        this.raf.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this.raf.writeChars(s);
    }

    public void writeUTF(String str) throws IOException {
        this.raf.writeUTF(str);
    }
}

