/*
 * Decompiled with CFR 0.152.
 */
package com.github.vbauer.vfs2.provider.smb;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericFileName;

public class SmbFileName
extends GenericFileName {
    public static final int DEFAULT_PORT = 139;
    private final String share;
    private final String domain;
    private String uriWithoutAuth;

    protected SmbFileName(String scheme, String hostName, int port, String userName, String password, String domain, String share, String path, FileType type) {
        super(scheme, hostName, port, 139, userName, password, path, type);
        this.share = share;
        this.domain = domain;
    }

    public String getShare() {
        return this.share;
    }

    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        super.appendRootUri(buffer, addPassword);
        buffer.append('/');
        buffer.append(this.share);
    }

    protected void appendCredentials(StringBuilder buffer, boolean addPassword) {
        String domain = this.getDomain();
        String userName = this.getUserName();
        if (domain != null && domain.length() != 0 && userName != null && userName.length() != 0) {
            buffer.append(domain);
            buffer.append("\\");
        }
        super.appendCredentials(buffer, addPassword);
    }

    public FileName createName(String path, FileType type) {
        return new SmbFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getUserName(), this.getPassword(), this.domain, this.share, path, type);
    }

    public String getUriWithoutAuth() throws FileSystemException {
        if (this.uriWithoutAuth != null) {
            return this.uriWithoutAuth;
        }
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getHostName());
        if (this.getPort() != 139) {
            sb.append(":");
            sb.append(this.getPort());
        }
        sb.append("/");
        sb.append(this.getShare());
        sb.append(this.getPathDecoded());
        this.uriWithoutAuth = sb.toString();
        return this.uriWithoutAuth;
    }

    public String getDomain() {
        return this.domain;
    }
}

