/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.TableDrawerFunction;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.CellBaseData;
import org.vandeseer.easytable.structure.cell.CellImage;
import org.vandeseer.easytable.structure.cell.CellText;
import org.vandeseer.easytable.util.PdfUtil;

public class TableDrawer {
    private PDPageContentStream contentStream;
    private final Table table;
    private float startX;
    private float startY;
    private float endY;
    private int rowToDraw = 0;
    private boolean isFinished = false;

    TableDrawer(float startX, float startY, PDPageContentStream contentStream, Table table, float endY) {
        this.contentStream = contentStream;
        this.table = table;
        this.startX = startX;
        this.startY = startY - PdfUtil.getFontHeight(table.getSettings().getFont(), table.getSettings().getFontSize());
        this.endY = endY;
    }

    public void draw() throws IOException {
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBackgroundColorAndCellContent, false);
        this.drawWithFunction(new Point2D.Float(this.startX, this.startY), this::drawBorders, true);
    }

    private void drawWithFunction(Point2D.Float startingPoint, TableDrawerFunction function, boolean isLastAction) throws IOException {
        float y = startingPoint.y;
        for (int i = this.rowToDraw; i < this.table.getRows().size(); ++i) {
            Row row = this.table.getRows().get(i);
            int columnCounter = 0;
            float lowestPoint = y - row.getCells().stream().map(CellBaseData::getHeight).max(Comparator.naturalOrder()).orElse(Float.valueOf(row.getHeight())).floatValue();
            if (lowestPoint < this.endY) {
                if (isLastAction) {
                    this.rowToDraw = i;
                }
                return;
            }
            float x = startingPoint.x;
            y -= row.getHeight();
            for (CellBaseData cell : row.getCells()) {
                while (this.table.isRowSpanAt(i, columnCounter)) {
                    x += this.table.getColumns().get(columnCounter).getWidth();
                    ++columnCounter;
                }
                float cellWidth = this.table.getAvailableCellWidthRespectingSpan(columnCounter, cell.getColSpan());
                function.accept(new Point2D.Float(x, y), row, cell, cellWidth);
                x += cellWidth;
                columnCounter += cell.getColSpan();
            }
        }
        if (isLastAction) {
            this.isFinished = true;
        }
    }

    private void drawBackgroundColorAndCellContent(Point2D.Float start, Row row, CellBaseData cell, float cellWidth) throws IOException {
        float y;
        float rowHeight = row.getHeight();
        float height = cell.getHeight() > rowHeight ? cell.getHeight() : rowHeight;
        float f = y = cell.getHeight() > rowHeight ? start.y + rowHeight - cell.getHeight() : start.y;
        if (cell.hasBackgroundColor()) {
            this.drawCellBackground(cell, start.x, y, cellWidth, height);
        }
        if (cell instanceof CellText) {
            this.drawCellText((CellText)cell, cellWidth, start.x, start.y);
        } else if (cell instanceof CellImage) {
            this.drawCellImage((CellImage)cell, cellWidth, start.x, y);
        }
    }

    private void drawBorders(Point2D.Float start, Row row, CellBaseData cell, float cellWidth) throws IOException {
        float rowHeight = row.getHeight();
        float height = cell.getHeight() > rowHeight ? cell.getHeight() : rowHeight;
        float sY = cell.getHeight() > rowHeight ? start.y + rowHeight - cell.getHeight() : start.y;
        Color cellBorderColor = cell.getBorderColor();
        Color rowBorderColor = row.getSettings().getBorderColor();
        if (cell.hasBorderTop() || cell.hasBorderBottom()) {
            float correctionLeft = cell.getBorderWidthLeft() / 2.0f;
            float correctionRight = cell.getBorderWidthRight() / 2.0f;
            if (cell.hasBorderTop()) {
                this.contentStream.moveTo(start.x - correctionLeft, start.y + rowHeight);
                this.drawLine(cellBorderColor, cell.getBorderWidthTop(), start.x + cellWidth + correctionRight, start.y + rowHeight);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
            if (cell.hasBorderBottom()) {
                this.contentStream.moveTo(start.x - correctionLeft, sY);
                this.drawLine(cellBorderColor, cell.getBorderWidthBottom(), start.x + cellWidth + correctionRight, sY);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
        }
        if (cell.hasBorderLeft() || cell.hasBorderRight()) {
            float correctionTop = cell.getBorderWidthTop() / 2.0f;
            float correctionBottom = cell.getBorderWidthBottom() / 2.0f;
            if (cell.hasBorderLeft()) {
                this.contentStream.moveTo(start.x, sY - correctionBottom);
                this.drawLine(cellBorderColor, cell.getBorderWidthLeft(), start.x, sY + height + correctionTop);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
            if (cell.hasBorderRight()) {
                this.contentStream.moveTo(start.x + cellWidth, sY - correctionBottom);
                this.drawLine(cellBorderColor, cell.getBorderWidthRight(), start.x + cellWidth, sY + height + correctionTop);
                this.contentStream.setStrokingColor(rowBorderColor);
            }
        }
    }

    private void drawCellText(CellText cell, float columnWidth, float moveX, float moveY) throws IOException {
        PDFont currentFont = cell.getFont();
        int currentFontSize = cell.getFontSize();
        Color currentTextColor = cell.getTextColor();
        float maxWidth = cell.getWidthOfText();
        List<String> lines = cell.isWordBreak() ? PdfUtil.getOptimalTextBreakLines(cell.getText(), currentFont, currentFontSize, maxWidth) : Collections.singletonList(cell.getText());
        float yStartRelative = cell.getRow().getHeight() - cell.getPaddingTop();
        if (cell.getRow().getHeight() > cell.getHeight() || cell.getRowSpan() > 1) {
            if (cell.getSettings().getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                float outerHeight = cell.getRowSpan() > 1 ? cell.getHeight() : cell.getRow().getHeight();
                yStartRelative = outerHeight / 2.0f + cell.getTextHeight() / 2.0f;
                if (cell.getRowSpan() > 1) {
                    float rowSpanAdaption = cell.calculateHeightForRowSpan() - cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            } else if (cell.getSettings().getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                yStartRelative = cell.getTextHeight() + cell.getPaddingBottom();
                if (cell.getRowSpan() > 1) {
                    float rowSpanAdaption = cell.calculateHeightForRowSpan() - cell.getRow().getHeight();
                    yStartRelative -= rowSpanAdaption;
                }
            }
        }
        float yOffset = moveY + yStartRelative;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            float xOffset = moveX + cell.getPaddingLeft();
            yOffset -= PdfUtil.getFontHeight(currentFont, currentFontSize) + (i > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * cell.getLineSpacing() : 0.0f);
            float textWidth = PdfUtil.getStringWidth(line, currentFont, currentFontSize);
            if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.RIGHT) {
                xOffset = moveX + (columnWidth - (textWidth + cell.getPaddingRight()));
            } else if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.CENTER) {
                float diff = (columnWidth - textWidth) / 2.0f;
                xOffset = moveX + diff;
            } else if (cell.getSettings().getHorizontalAlignment() == HorizontalAlignment.JUSTIFY) {
                float charSpacing = 0.0f;
                if (line.length() > 1) {
                    float size = PdfUtil.getStringWidth(line, cell.getFont(), cell.getFontSize());
                    float free = cell.getWidthOfText() - size;
                    if (free > 0.0f) {
                        charSpacing = free / (float)(line.length() - 1);
                    }
                }
                if (i < lines.size() - 1) {
                    this.contentStream.setCharacterSpacing(charSpacing);
                }
            }
            this.drawText(line, currentFont, currentFontSize, currentTextColor, xOffset, yOffset);
        }
    }

    private void drawCellImage(CellImage cell, float columnWidth, float moveX, float moveY) throws IOException {
        Point2D.Float size = cell.getFitSize();
        Point2D.Float drawAt = new Point2D.Float();
        drawAt.x = moveX + (columnWidth - cell.getHorizontalPadding()) / 2.0f + cell.getPaddingLeft() - size.x / 2.0f;
        drawAt.y = moveY + (cell.getHeight() - cell.getVerticalPadding()) / 2.0f + cell.getPaddingBottom() - size.y / 2.0f;
        this.contentStream.drawImage(cell.getImage(), drawAt.x, drawAt.y, size.x, size.y);
    }

    private void drawLine(Color color, float width, float toX, float toY) throws IOException {
        this.contentStream.setLineWidth(width);
        this.contentStream.lineTo(toX, toY);
        this.contentStream.setStrokingColor(color);
        this.contentStream.stroke();
    }

    private void drawCellBackground(CellBaseData cell, float startX, float startY, float width, float height) throws IOException {
        this.contentStream.setNonStrokingColor(cell.getBackgroundColor());
        this.contentStream.addRect(startX, startY, width, height);
        this.contentStream.fill();
        this.contentStream.closePath();
        this.contentStream.setNonStrokingColor(Color.BLACK);
    }

    private void drawText(String text, PDFont font, int fontSize, Color color, float x, float y) throws IOException {
        this.contentStream.beginText();
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.setFont(font, (float)fontSize);
        this.contentStream.newLineAtOffset(x, y);
        this.contentStream.showText(text);
        this.contentStream.endText();
        this.contentStream.setCharacterSpacing(0.0f);
    }

    public static TableDrawerBuilder builder() {
        return new TableDrawerBuilder();
    }

    public TableDrawer contentStream(PDPageContentStream contentStream) {
        this.contentStream = contentStream;
        return this;
    }

    public TableDrawer startX(float startX) {
        this.startX = startX;
        return this;
    }

    public TableDrawer startY(float startY) {
        this.startY = startY;
        return this;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public static class TableDrawerBuilder {
        private float startX;
        private float startY;
        private PDPageContentStream contentStream;
        private Table table;
        private float endY;

        TableDrawerBuilder() {
        }

        public TableDrawerBuilder startX(float startX) {
            this.startX = startX;
            return this;
        }

        public TableDrawerBuilder startY(float startY) {
            this.startY = startY;
            return this;
        }

        public TableDrawerBuilder contentStream(PDPageContentStream contentStream) {
            this.contentStream = contentStream;
            return this;
        }

        public TableDrawerBuilder table(Table table) {
            this.table = table;
            return this;
        }

        public TableDrawerBuilder endY(float endY) {
            this.endY = endY;
            return this;
        }

        public TableDrawer build() {
            return new TableDrawer(this.startX, this.startY, this.contentStream, this.table, this.endY);
        }

        public String toString() {
            return "TableDrawer.TableDrawerBuilder(startX=" + this.startX + ", startY=" + this.startY + ", contentStream=" + this.contentStream + ", table=" + this.table + ", endY=" + this.endY + ")";
        }
    }
}

