/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.Color;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.TableNotYetBuiltException;

public abstract class CellBaseData {
    private Row row;
    private Column column;
    protected Settings settings;
    private final int span;
    private final float paddingLeft;
    private final float paddingRight;
    private final float paddingTop;
    private final float paddingBottom;
    private float borderWidthTop;
    private float borderWidthLeft;
    private float borderWidthRight;
    private float borderWidthBottom;

    public float getHorizontalPadding() {
        return this.getPaddingLeft() + this.getPaddingRight();
    }

    public float getVerticalPadding() {
        return this.getPaddingTop() + this.getPaddingBottom();
    }

    public boolean hasBorderTop() {
        return this.getBorderWidthTop() > 0.0f;
    }

    public boolean hasBorderBottom() {
        return this.getBorderWidthBottom() > 0.0f;
    }

    public boolean hasBorderLeft() {
        return this.getBorderWidthLeft() > 0.0f;
    }

    public boolean hasBorderRight() {
        return this.getBorderWidthRight() > 0.0f;
    }

    public boolean hasBackgroundColor() {
        return this.settings.getBackgroundColor() != null;
    }

    public Color getBackgroundColor() {
        return this.settings.getBackgroundColor();
    }

    public Color getBorderColor() {
        return this.settings.getBorderColor();
    }

    public boolean isWordBreak() {
        return this.settings.isWordBreak();
    }

    public abstract float getHeight();

    void assertIsRendered() {
        if (this.column == null || this.row == null) {
            throw new TableNotYetBuiltException();
        }
    }

    private static int $default$span() {
        return 1;
    }

    private static float $default$paddingLeft() {
        return 4.0f;
    }

    private static float $default$paddingRight() {
        return 4.0f;
    }

    private static float $default$paddingTop() {
        return 4.0f;
    }

    private static float $default$paddingBottom() {
        return 4.0f;
    }

    private static float $default$borderWidthTop() {
        return 0.0f;
    }

    private static float $default$borderWidthLeft() {
        return 0.0f;
    }

    private static float $default$borderWidthRight() {
        return 0.0f;
    }

    private static float $default$borderWidthBottom() {
        return 0.0f;
    }

    protected CellBaseData(CellBaseDataBuilder<?, ?> b) {
        this.row = ((CellBaseDataBuilder)b).row;
        this.column = ((CellBaseDataBuilder)b).column;
        this.settings = b.settings;
        this.span = ((CellBaseDataBuilder)b).span$set ? ((CellBaseDataBuilder)b).span : CellBaseData.$default$span();
        this.paddingLeft = ((CellBaseDataBuilder)b).paddingLeft$set ? ((CellBaseDataBuilder)b).paddingLeft : CellBaseData.$default$paddingLeft();
        this.paddingRight = ((CellBaseDataBuilder)b).paddingRight$set ? ((CellBaseDataBuilder)b).paddingRight : CellBaseData.$default$paddingRight();
        this.paddingTop = ((CellBaseDataBuilder)b).paddingTop$set ? ((CellBaseDataBuilder)b).paddingTop : CellBaseData.$default$paddingTop();
        this.paddingBottom = ((CellBaseDataBuilder)b).paddingBottom$set ? ((CellBaseDataBuilder)b).paddingBottom : CellBaseData.$default$paddingBottom();
        this.borderWidthTop = ((CellBaseDataBuilder)b).borderWidthTop$set ? ((CellBaseDataBuilder)b).borderWidthTop : CellBaseData.$default$borderWidthTop();
        this.borderWidthLeft = ((CellBaseDataBuilder)b).borderWidthLeft$set ? ((CellBaseDataBuilder)b).borderWidthLeft : CellBaseData.$default$borderWidthLeft();
        this.borderWidthRight = ((CellBaseDataBuilder)b).borderWidthRight$set ? ((CellBaseDataBuilder)b).borderWidthRight : CellBaseData.$default$borderWidthRight();
        this.borderWidthBottom = ((CellBaseDataBuilder)b).borderWidthBottom$set ? ((CellBaseDataBuilder)b).borderWidthBottom : CellBaseData.$default$borderWidthBottom();
    }

    public Row getRow() {
        return this.row;
    }

    public Column getColumn() {
        return this.column;
    }

    public int getSpan() {
        return this.span;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public float getBorderWidthTop() {
        return this.borderWidthTop;
    }

    public float getBorderWidthLeft() {
        return this.borderWidthLeft;
    }

    public float getBorderWidthRight() {
        return this.borderWidthRight;
    }

    public float getBorderWidthBottom() {
        return this.borderWidthBottom;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected void setSettings(Settings settings) {
        this.settings = settings;
    }

    public static abstract class CellBaseDataBuilder<C extends CellBaseData, B extends CellBaseDataBuilder<C, B>> {
        private Row row;
        private Column column;
        private boolean span$set;
        private int span;
        private boolean paddingLeft$set;
        private float paddingLeft;
        private boolean paddingRight$set;
        private float paddingRight;
        private boolean paddingTop$set;
        private float paddingTop;
        private boolean paddingBottom$set;
        private float paddingBottom;
        private boolean borderWidthTop$set;
        private float borderWidthTop;
        private boolean borderWidthLeft$set;
        private float borderWidthLeft;
        private boolean borderWidthRight$set;
        private float borderWidthRight;
        private boolean borderWidthBottom$set;
        private float borderWidthBottom;
        protected Settings settings = Settings.builder().build();

        public B borderWidth(float borderWidth) {
            return ((CellBaseDataBuilder)((CellBaseDataBuilder)((CellBaseDataBuilder)this.borderWidthTop(borderWidth)).borderWidthBottom(borderWidth)).borderWidthLeft(borderWidth)).borderWidthRight(borderWidth);
        }

        public B padding(float padding) {
            return ((CellBaseDataBuilder)((CellBaseDataBuilder)((CellBaseDataBuilder)this.paddingTop(padding)).paddingBottom(padding)).paddingLeft(padding)).paddingRight(padding);
        }

        public B horizontalAlignment(HorizontalAlignment alignment) {
            this.settings.setHorizontalAlignment(alignment);
            return this.self();
        }

        public B verticalAlignment(VerticalAlignment alignment) {
            this.settings.setVerticalAlignment(alignment);
            return this.self();
        }

        public B backgroundColor(Color backgroundColor) {
            this.settings.setBackgroundColor(backgroundColor);
            return this.self();
        }

        public B borderColor(Color borderColor) {
            this.settings.setBorderColor(borderColor);
            return this.self();
        }

        public B wordBreak(Boolean wordBreak) {
            this.settings.setWordBreak(wordBreak);
            return this.self();
        }

        protected B $fillValuesFrom(C instance) {
            CellBaseDataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CellBaseData instance, CellBaseDataBuilder<?, ?> b) {
            b.row(instance.row);
            b.column(instance.column);
            b.settings(instance.settings);
            b.span(instance.span);
            b.paddingLeft(instance.paddingLeft);
            b.paddingRight(instance.paddingRight);
            b.paddingTop(instance.paddingTop);
            b.paddingBottom(instance.paddingBottom);
            b.borderWidthTop(instance.borderWidthTop);
            b.borderWidthLeft(instance.borderWidthLeft);
            b.borderWidthRight(instance.borderWidthRight);
            b.borderWidthBottom(instance.borderWidthBottom);
        }

        protected abstract B self();

        public abstract C build();

        public B row(Row row) {
            this.row = row;
            return this.self();
        }

        public B column(Column column) {
            this.column = column;
            return this.self();
        }

        public B settings(Settings settings) {
            this.settings = settings;
            return this.self();
        }

        public B span(int span) {
            this.span = span;
            this.span$set = true;
            return this.self();
        }

        public B paddingLeft(float paddingLeft) {
            this.paddingLeft = paddingLeft;
            this.paddingLeft$set = true;
            return this.self();
        }

        public B paddingRight(float paddingRight) {
            this.paddingRight = paddingRight;
            this.paddingRight$set = true;
            return this.self();
        }

        public B paddingTop(float paddingTop) {
            this.paddingTop = paddingTop;
            this.paddingTop$set = true;
            return this.self();
        }

        public B paddingBottom(float paddingBottom) {
            this.paddingBottom = paddingBottom;
            this.paddingBottom$set = true;
            return this.self();
        }

        public B borderWidthTop(float borderWidthTop) {
            this.borderWidthTop = borderWidthTop;
            this.borderWidthTop$set = true;
            return this.self();
        }

        public B borderWidthLeft(float borderWidthLeft) {
            this.borderWidthLeft = borderWidthLeft;
            this.borderWidthLeft$set = true;
            return this.self();
        }

        public B borderWidthRight(float borderWidthRight) {
            this.borderWidthRight = borderWidthRight;
            this.borderWidthRight$set = true;
            return this.self();
        }

        public B borderWidthBottom(float borderWidthBottom) {
            this.borderWidthBottom = borderWidthBottom;
            this.borderWidthBottom$set = true;
            return this.self();
        }

        public String toString() {
            return "CellBaseData.CellBaseDataBuilder(row=" + this.row + ", column=" + this.column + ", settings=" + this.settings + ", span=" + this.span + ", paddingLeft=" + this.paddingLeft + ", paddingRight=" + this.paddingRight + ", paddingTop=" + this.paddingTop + ", paddingBottom=" + this.paddingBottom + ", borderWidthTop=" + this.borderWidthTop + ", borderWidthLeft=" + this.borderWidthLeft + ", borderWidthRight=" + this.borderWidthRight + ", borderWidthBottom=" + this.borderWidthBottom + ")";
        }
    }
}

