/*
 * Decompiled with CFR 0.152.
 */
package com.luciad.imageio.webp.internal;

import com.luciad.imageio.webp.internal.JavaUtilsKt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0007\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u000fR\u001a\u0010\u001a\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/luciad/imageio/webp/internal/OsInfo;", "", "()V", "IA64", "", "IA64_32", "PPC", "PPC64", "X86", "X86_64", "archMapping", "", "archName", "getArchName$annotations", "getArchName", "()Ljava/lang/String;", "hardwareName", "getHardwareName$annotations", "getHardwareName", "isAlpine", "", "()Z", "isAndroid", "nativeLibFolderPathForCurrentOS", "getNativeLibFolderPathForCurrentOS$annotations", "getNativeLibFolderPathForCurrentOS", "oSName", "getOSName$annotations", "getOSName", "main", "", "arg", "", "([Ljava/lang/String;)V", "resolveArmArchType", "translateArchNameToFolderName", "translateOSNameToFolderName", "osName", "webp-imageio"})
@SourceDebugExtension(value={"SMAP\nOsInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OsInfo.kt\ncom/luciad/imageio/webp/internal/OsInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public final class OsInfo {
    @NotNull
    public static final OsInfo INSTANCE = new OsInfo();
    @NotNull
    private static final String X86 = "x86";
    @NotNull
    private static final String X86_64 = "x86_64";
    @NotNull
    private static final String IA64_32 = "ia64_32";
    @NotNull
    private static final String IA64 = "ia64";
    @NotNull
    private static final String PPC = "ppc";
    @NotNull
    private static final String PPC64 = "ppc64";
    @NotNull
    private static final Map<String, String> archMapping;

    private OsInfo() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        System.out.println((Object)("osName=" + INSTANCE.getOSName()));
        System.out.println((Object)("archName=" + INSTANCE.getArchName()));
        System.out.println((Object)("hardwareName=" + INSTANCE.getHardwareName()));
        System.out.println((Object)("isAlpine=" + INSTANCE.isAlpine()));
        System.out.println((Object)("nativeLibFolderPathForCurrentOS=" + INSTANCE.getNativeLibFolderPathForCurrentOS()));
    }

    @NotNull
    public static final String getNativeLibFolderPathForCurrentOS() {
        return INSTANCE.getOSName() + '/' + INSTANCE.getArchName();
    }

    @JvmStatic
    public static /* synthetic */ void getNativeLibFolderPathForCurrentOS$annotations() {
    }

    @NotNull
    public static final String getOSName() {
        String string = JavaUtilsKt.findProperty("os.name");
        if (string == null) {
            string = "";
        }
        return INSTANCE.translateOSNameToFolderName(string);
    }

    @JvmStatic
    public static /* synthetic */ void getOSName$annotations() {
    }

    private final boolean isAndroid() {
        String string = JavaUtilsKt.findProperty("java.runtime.name");
        if (string == null) {
            string = "";
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"android", (boolean)false, (int)2, null);
    }

    private final boolean isAlpine() {
        Object object;
        Object object2 = this;
        try {
            OsInfo $this$_get_isAlpine__u24lambda_u240 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"cat /etc/os-release | grep ^ID"};
            String osReleaseOutput = (String)JavaUtilsKt.runProcess(stringArray).component2();
            object = Result.constructor-impl((Object)StringsKt.contains((CharSequence)osReleaseOutput, (CharSequence)"alpine", (boolean)true));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private final String getHardwareName() {
        Object object;
        Object object2 = this;
        try {
            OsInfo $this$_get_hardwareName__u24lambda_u241 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"uname", "-m"};
            object = Result.constructor-impl((Object)((String)JavaUtilsKt.runProcess(stringArray).getSecond()));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            System.err.println("Error while running uname -m: " + ((Throwable)it).getMessage());
        }
        object = "unknown";
        return (String)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private static /* synthetic */ void getHardwareName$annotations() {
    }

    private final String resolveArmArchType() {
        String string = JavaUtilsKt.findProperty("os.name");
        if (string == null) {
            string = "";
        }
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Linux", (boolean)false, (int)2, null)) {
            String abi;
            String armType = this.getHardwareName();
            if (StringsKt.startsWith$default((String)armType, (String)"armv6", (boolean)false, (int)2, null)) {
                return "armv6";
            }
            if (StringsKt.startsWith$default((String)armType, (String)"armv7l", (boolean)false, (int)2, null)) {
                return "armv7l";
            }
            if (StringsKt.startsWith$default((String)armType, (String)"armv7", (boolean)false, (int)2, null)) {
                return "armv7";
            }
            if (StringsKt.startsWith$default((String)armType, (String)"armv5", (boolean)false, (int)2, null)) {
                return "arm";
            }
            if (Intrinsics.areEqual((Object)armType, (Object)"aarch64")) {
                return "arm64";
            }
            String string2 = JavaUtilsKt.findProperty("sun.arch.abi");
            if (string2 == null) {
                string2 = "";
            }
            if (StringsKt.startsWith$default((String)(abi = string2), (String)"gnueabihf", (boolean)false, (int)2, null)) {
                return "armv7";
            }
            String string3 = JavaUtilsKt.findProperty("java.home");
            if (string3 == null) {
                string3 = "";
            }
            String javaHome = string3;
            try {
                String[] stringArray = new String[]{"which", "readelf"};
                Pair<Integer, String> pair = JavaUtilsKt.runProcess(stringArray);
                int readelfExitCode = ((Number)pair.component1()).intValue();
                if (readelfExitCode == 0) {
                    String[] stringArray2 = new String[]{"/bin/sh", "-c", "find '" + javaHome + "' -name 'libjvm.so' | head -1 | xargs readelf -A | grep 'Tag_ABI_VFP_args: VFP registers'"};
                    String[] cmdArray = stringArray2;
                    int abiFinderExitCode = ((Number)JavaUtilsKt.runProcess(Arrays.copyOf(cmdArray, cmdArray.length)).component1()).intValue();
                    if (abiFinderExitCode == 0) {
                        return "armv7";
                    }
                } else {
                    System.err.println("WARNING! readelf not found. Cannot check if running on an armhf system, armel architecture will be presumed.");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "arm";
    }

    @Nullable
    public static final String getArchName() {
        String osArch;
        String string = JavaUtilsKt.findProperty("os.arch");
        if (string == null) {
            string = osArch = "";
        }
        if (INSTANCE.isAndroid()) {
            return "android-arm";
        }
        if (StringsKt.startsWith$default((String)osArch, (String)"arm", (boolean)false, (int)2, null)) {
            osArch = INSTANCE.resolveArmArchType();
        } else {
            String string2 = osArch.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String lc = string2;
            if (archMapping.containsKey(lc)) {
                return archMapping.get(lc);
            }
        }
        return INSTANCE.translateArchNameToFolderName(osArch);
    }

    @JvmStatic
    public static /* synthetic */ void getArchName$annotations() {
    }

    private final String translateOSNameToFolderName(String osName) {
        String string;
        if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Windows", (boolean)false, (int)2, null)) {
            string = "Windows";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"Darwin", (boolean)false, (int)2, null)) {
            string = "Mac";
        } else if (this.isAlpine()) {
            string = "Linux-Alpine";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Linux", (boolean)false, (int)2, null)) {
            string = "Linux";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"AIX", (boolean)false, (int)2, null)) {
            string = "AIX";
        } else {
            CharSequence charSequence = osName;
            Regex regex = new Regex("\\W");
            String string2 = "";
            string = regex.replace(charSequence, string2);
        }
        return string;
    }

    private final String translateArchNameToFolderName(String archName) {
        CharSequence charSequence = archName;
        Regex regex = new Regex("\\W");
        String string = "";
        return regex.replace(charSequence, string);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)X86, (Object)X86), TuplesKt.to((Object)"i386", (Object)X86), TuplesKt.to((Object)"i486", (Object)X86), TuplesKt.to((Object)"i586", (Object)X86), TuplesKt.to((Object)"i686", (Object)X86), TuplesKt.to((Object)"pentium", (Object)X86), TuplesKt.to((Object)X86_64, (Object)X86_64), TuplesKt.to((Object)"amd64", (Object)X86_64), TuplesKt.to((Object)"em64t", (Object)X86_64), TuplesKt.to((Object)"universal", (Object)X86_64), TuplesKt.to((Object)IA64, (Object)IA64), TuplesKt.to((Object)"ia64w", (Object)IA64), TuplesKt.to((Object)IA64_32, (Object)IA64_32), TuplesKt.to((Object)"ia64n", (Object)IA64_32), TuplesKt.to((Object)PPC, (Object)PPC), TuplesKt.to((Object)"power", (Object)PPC), TuplesKt.to((Object)"powerpc", (Object)PPC), TuplesKt.to((Object)"power_pc", (Object)PPC), TuplesKt.to((Object)"power_rs", (Object)PPC), TuplesKt.to((Object)PPC64, (Object)PPC64), TuplesKt.to((Object)"power64", (Object)PPC64), TuplesKt.to((Object)"powerpc64", (Object)PPC64), TuplesKt.to((Object)"power_pc64", (Object)PPC64), TuplesKt.to((Object)"power_rs64", (Object)PPC64)};
        archMapping = MapsKt.mapOf((Pair[])pairArray);
    }
}

