/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.jdbcdslog.ConfigurationParameters;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.ResultSetLoggingProxy;
import org.jdbcdslog.SlowQueryLogger;
import org.jdbcdslog.StatementLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementLoggingProxy
implements InvocationHandler {
    static Logger logger = LoggerFactory.getLogger(PreparedStatementLoggingProxy.class);
    TreeMap parameters = new TreeMap();
    Object target = null;
    String sql = null;
    static List setMethods = Arrays.asList("setAsciiStream", "setBigDecimal", "setBinaryStream", "setBoolean", "setByte", "setBytes", "setCharacterStream", "setDate", "setDouble", "setFloat", "setInt", "setLong", "setObject", "setShort", "setString", "setTime", "setTimestamp", "setURL");
    static List executeMethods = Arrays.asList("addBatch", "execute", "executeQuery", "executeUpdate");

    public PreparedStatementLoggingProxy(PreparedStatement ps, String sql) {
        this.target = ps;
        this.sql = sql;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object r = null;
        try {
            boolean toLog;
            long t1 = 0L;
            boolean bl = toLog = (StatementLogger.isInfoEnabled() || SlowQueryLogger.isInfoEnabled()) && executeMethods.contains(method.getName());
            if (toLog) {
                t1 = System.currentTimeMillis();
            }
            r = method.invoke(this.target, args);
            if (setMethods.contains(method.getName()) && args[0] instanceof Integer) {
                this.parameters.put(args[0], args[1]);
            }
            if ("clearParameters".equals(method.getName())) {
                this.parameters = new TreeMap();
            }
            if (toLog) {
                StringBuffer sb = LogUtils.createLogEntry(this.sql, this.parameters);
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                if (ConfigurationParameters.showTime.booleanValue()) {
                    sb.append(" ").append(t2 - t1).append(" ms.");
                }
                StatementLogger.info(sb.toString());
                if (time >= ConfigurationParameters.slowQueryThreshold) {
                    SlowQueryLogger.info(sb.toString());
                }
            }
            if (r instanceof ResultSet) {
                r = ResultSetLoggingProxy.wrapByResultSetProxy((ResultSet)r);
            }
        }
        catch (Throwable t) {
            LogUtils.handleException(t, StatementLogger.getLogger(), LogUtils.createLogEntry(this.sql, this.parameters));
        }
        return r;
    }

    String parametersToString() {
        StringBuffer sb2 = new StringBuffer();
        sb2.setLength(0);
        sb2.append("{");
        int maxParamNumber = 0;
        if (this.parameters.size() > 0) {
            maxParamNumber = (Integer)this.parameters.lastKey();
        }
        if (maxParamNumber > 0) {
            Integer key = new Integer(1);
            if (this.parameters.containsKey(key)) {
                sb2.append(ConfigurationParameters.rdbmsSpecifics.formatParameter(this.parameters.get(key)));
            } else {
                sb2.append("(null)");
            }
        }
        for (int i = 2; i <= maxParamNumber; ++i) {
            Integer key = new Integer(i);
            sb2.append(", ");
            if (this.parameters.containsKey(key)) {
                sb2.append(ConfigurationParameters.rdbmsSpecifics.formatParameter(this.parameters.get(key)));
                continue;
            }
            sb2.append("(null)");
        }
        sb2.append("}");
        return sb2.toString();
    }
}

