/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.caching;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

@Order(value=0x7FFFFFF5)
public class RefreshScopeRefreshedEventListener
implements ApplicationListener<ApplicationEvent>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RefreshScopeRefreshedEventListener.class);
    public static final List<String> EVENT_CLASS_NAMES = Arrays.asList("org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent", "org.springframework.cloud.context.environment.EnvironmentChangeEvent", "org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent");
    private final ConfigurableEnvironment environment;
    private final EncryptablePropertySourceConverter converter;
    private final List<Class<?>> eventClasses = new ArrayList();
    private final Map<String, Boolean> eventTriggersCache = new ConcurrentHashMap<String, Boolean>();
    private final JasyptEncryptorConfigurationProperties config;

    public RefreshScopeRefreshedEventListener(ConfigurableEnvironment environment, EncryptablePropertySourceConverter converter, JasyptEncryptorConfigurationProperties config) {
        this.environment = environment;
        this.converter = converter;
        this.config = config;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.shouldTriggerRefresh(event)) {
            log.info("Refreshing cached encryptable property sources on {}", (Object)event.getClass().getSimpleName());
            this.refreshCachedProperties();
            this.decorateNewSources();
        }
    }

    private boolean shouldTriggerRefresh(ApplicationEvent event) {
        String className = event.getClass().getName();
        if (!this.eventTriggersCache.containsKey(className)) {
            this.eventTriggersCache.put(className, this.eventClasses.stream().anyMatch(clazz -> this.isAssignable((Class<?>)clazz, event)));
        }
        return this.eventTriggersCache.get(className);
    }

    private void decorateNewSources() {
        MutablePropertySources propSources = this.environment.getPropertySources();
        this.converter.convertPropertySources(propSources);
    }

    boolean isAssignable(Class<?> clazz, Object value) {
        return ClassUtils.isAssignableValue(clazz, (Object)value);
    }

    private void refreshCachedProperties() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        propertySources.forEach(this::refreshPropertySource);
    }

    private void refreshPropertySource(PropertySource<?> propertySource) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)propertySource;
            cps.getPropertySources().forEach(this::refreshPropertySource);
        } else if (propertySource instanceof EncryptablePropertySource) {
            EncryptablePropertySource eps = (EncryptablePropertySource)propertySource;
            eps.refresh();
        }
    }

    private Class<?> getClassSafe(String className) {
        try {
            return ClassUtils.forName((String)className, null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Stream.concat(EVENT_CLASS_NAMES.stream(), this.config.getRefreshedEventClasses().stream()).map(this::getClassSafe).filter(Objects::nonNull).collect(Collectors.toCollection(() -> this.eventClasses));
    }
}

