/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.filter;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.filter.DefaultPropertyFilter;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.util.Functional;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class DefaultLazyPropertyFilter
implements EncryptablePropertyFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyPropertyFilter.class);
    private Singleton<EncryptablePropertyFilter> singleton;

    public DefaultLazyPropertyFilter(ConfigurableEnvironment e, String customFilterBeanName, boolean isCustom, BeanFactory bf) {
        this.singleton = new Singleton<EncryptablePropertyFilter>(() -> Optional.of(customFilterBeanName).filter(arg_0 -> ((BeanFactory)bf).containsBean(arg_0)).map(name -> (EncryptablePropertyFilter)bf.getBean(name)).map(Functional.tap(bean -> log.info("Found Custom Filter Bean {} with name: {}", bean, (Object)customFilterBeanName))).orElseGet(() -> {
            if (isCustom) {
                throw new IllegalStateException(String.format("Property Filter custom Bean not found with name '%s'", customFilterBeanName));
            }
            log.info("Property Filter custom Bean not found with name '{}'. Initializing Default Property Filter", (Object)customFilterBeanName);
            return this.createDefault(e);
        }));
    }

    public DefaultLazyPropertyFilter(ConfigurableEnvironment environment) {
        this.singleton = new Singleton<EncryptablePropertyFilter>(() -> this.createDefault(environment));
    }

    private DefaultPropertyFilter createDefault(ConfigurableEnvironment environment) {
        JasyptEncryptorConfigurationProperties props = JasyptEncryptorConfigurationProperties.bindConfigProps(environment);
        JasyptEncryptorConfigurationProperties.PropertyConfigurationProperties.FilterConfigurationProperties filterConfig = props.getProperty().getFilter();
        return new DefaultPropertyFilter(filterConfig.getIncludeSources(), filterConfig.getExcludeSources(), filterConfig.getIncludeNames(), filterConfig.getExcludeNames());
    }

    @Override
    public boolean shouldInclude(PropertySource<?> source, String name) {
        return this.singleton.get().shouldInclude(source, name);
    }
}

