/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.configuration.EnvCopy;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultLazyPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.filter.DefaultLazyPropertyFilter;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultLazyPropertyResolver;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.web.context.support.StandardServletEnvironment;

public class StandardEncryptableServletEnvironment
extends StandardServletEnvironment
implements ConfigurableEnvironment {
    private MutablePropertySources encryptablePropertySources;
    private MutablePropertySources originalPropertySources;

    public StandardEncryptableServletEnvironment() {
        this(null, null, null, null, null, null);
    }

    public StandardEncryptableServletEnvironment(InterceptionMode interceptionMode, List<Class<PropertySource<?>>> skipPropertySourceClasses, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        InterceptionMode actualInterceptionMode = Optional.ofNullable(interceptionMode).orElse(InterceptionMode.WRAPPER);
        List actualSkipPropertySourceClasses = Optional.ofNullable(skipPropertySourceClasses).orElseGet(Collections::emptyList);
        EnvCopy envCopy = new EnvCopy(this);
        EncryptablePropertyFilter actualFilter = Optional.ofNullable(filter).orElseGet(() -> new DefaultLazyPropertyFilter(envCopy.get()));
        StringEncryptor actualEncryptor = Optional.ofNullable(encryptor).orElseGet(() -> new DefaultLazyEncryptor(envCopy.get()));
        EncryptablePropertyDetector actualDetector = Optional.ofNullable(detector).orElseGet(() -> new DefaultLazyPropertyDetector(envCopy.get()));
        EncryptablePropertyResolver actualResolver = Optional.ofNullable(resolver).orElseGet(() -> new DefaultLazyPropertyResolver(actualDetector, actualEncryptor, (Environment)this));
        EncryptablePropertySourceConverter.convertPropertySources(actualInterceptionMode, actualSkipPropertySourceClasses, actualResolver, actualFilter, this.originalPropertySources);
        this.encryptablePropertySources = EncryptablePropertySourceConverter.proxyPropertySources(actualInterceptionMode, actualSkipPropertySourceClasses, actualResolver, actualFilter, this.originalPropertySources, envCopy);
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
        super.customizePropertySources(propertySources);
        this.originalPropertySources = propertySources;
    }

    public MutablePropertySources getPropertySources() {
        return this.encryptablePropertySources;
    }

    public static StandardEncryptableServletEnvironmentBuilder builder() {
        return new StandardEncryptableServletEnvironmentBuilder();
    }

    public static class StandardEncryptableServletEnvironmentBuilder {
        private InterceptionMode interceptionMode;
        private List<Class<PropertySource<?>>> skipPropertySourceClasses;
        private EncryptablePropertyResolver resolver;
        private EncryptablePropertyFilter filter;
        private StringEncryptor encryptor;
        private EncryptablePropertyDetector detector;

        StandardEncryptableServletEnvironmentBuilder() {
        }

        public StandardEncryptableServletEnvironmentBuilder interceptionMode(InterceptionMode interceptionMode) {
            this.interceptionMode = interceptionMode;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder skipPropertySourceClasses(List<Class<PropertySource<?>>> skipPropertySourceClasses) {
            this.skipPropertySourceClasses = skipPropertySourceClasses;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder resolver(EncryptablePropertyResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder filter(EncryptablePropertyFilter filter) {
            this.filter = filter;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder encryptor(StringEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public StandardEncryptableServletEnvironmentBuilder detector(EncryptablePropertyDetector detector) {
            this.detector = detector;
            return this;
        }

        public StandardEncryptableServletEnvironment build() {
            return new StandardEncryptableServletEnvironment(this.interceptionMode, this.skipPropertySourceClasses, this.resolver, this.filter, this.encryptor, this.detector);
        }

        public String toString() {
            return "StandardEncryptableServletEnvironment.StandardEncryptableServletEnvironmentBuilder(interceptionMode=" + (Object)((Object)this.interceptionMode) + ", skipPropertySourceClasses=" + this.skipPropertySourceClasses + ", resolver=" + this.resolver + ", filter=" + this.filter + ", encryptor=" + this.encryptor + ", detector=" + this.detector + ")";
        }
    }
}

