/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

class BeanNamePlaceholderRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(BeanNamePlaceholderRegistryPostProcessor.class);
    private Environment environment;

    BeanNamePlaceholderRegistryPostProcessor(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DefaultListableBeanFactory bf = (DefaultListableBeanFactory)registry;
        Stream.of(bf.getBeanDefinitionNames()).filter(name -> name.matches("\\$\\{[\\w.-]+(?>:[\\w.-]+)?\\}")).forEach(placeholder -> {
            String actualName = this.environment.resolveRequiredPlaceholders(placeholder);
            BeanDefinition bd = bf.getBeanDefinition(placeholder);
            bf.removeBeanDefinition(placeholder);
            bf.registerBeanDefinition(actualName, bd);
            log.debug("Registering new name '{}' for Bean definition with placeholder name: {}", (Object)actualName, placeholder);
        });
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

