/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.environment;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.encryptor.DefaultLazyEncryptor;
import com.ulisesbocchio.jasyptspringboot.resolver.DefaultPropertyResolver;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.StandardEnvironment;

public class StandardEncryptableEnvironment
extends StandardEnvironment
implements ConfigurableEnvironment {
    private final EncryptablePropertyResolver resolver;
    private final InterceptionMode interceptionMode;
    private MutablePropertySources encryptablePropertySources;
    private MutablePropertySources originalPropertySources;

    public StandardEncryptableEnvironment() {
        this(InterceptionMode.WRAPPER);
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode) {
        this.interceptionMode = interceptionMode;
        this.resolver = new DefaultPropertyResolver(new DefaultLazyEncryptor((Environment)this), new DefaultPropertyDetector());
        this.actuallyCustomizePropertySources();
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, EncryptablePropertyDetector detector) {
        this.interceptionMode = interceptionMode;
        this.resolver = new DefaultPropertyResolver(new DefaultLazyEncryptor((Environment)this), detector);
        this.actuallyCustomizePropertySources();
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, StringEncryptor encryptor) {
        this.interceptionMode = interceptionMode;
        this.resolver = new DefaultPropertyResolver(encryptor, new DefaultPropertyDetector());
        this.actuallyCustomizePropertySources();
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, StringEncryptor encryptor, EncryptablePropertyDetector detector) {
        this.interceptionMode = interceptionMode;
        this.resolver = new DefaultPropertyResolver(encryptor, detector);
        this.actuallyCustomizePropertySources();
    }

    public StandardEncryptableEnvironment(InterceptionMode interceptionMode, EncryptablePropertyResolver resolver) {
        this.interceptionMode = interceptionMode;
        this.resolver = resolver;
        this.actuallyCustomizePropertySources();
    }

    protected void customizePropertySources(MutablePropertySources propertySources) {
        super.customizePropertySources(propertySources);
        this.originalPropertySources = propertySources;
    }

    protected void actuallyCustomizePropertySources() {
        EncryptablePropertySourceConverter.convertPropertySources(this.interceptionMode, this.resolver, this.originalPropertySources);
        this.encryptablePropertySources = EncryptablePropertySourceConverter.proxyPropertySources(this.interceptionMode, this.resolver, this.originalPropertySources);
    }

    public MutablePropertySources getPropertySources() {
        return this.encryptablePropertySources;
    }
}

