/*
 * Decompiled with CFR 0.152.
 */
package com.wei.android.lib.fingerprintidentify.impl;

import android.content.Context;
import com.samsung.android.sdk.pass.Spass;
import com.samsung.android.sdk.pass.SpassFingerprint;
import com.samsung.android.sdk.pass.SpassInvalidStateException;
import com.wei.android.lib.fingerprintidentify.base.BaseFingerprint;

public class SamsungFingerprint
extends BaseFingerprint {
    private int mResultCode = -1;
    private SpassFingerprint mSpassFingerprint;

    public SamsungFingerprint(Context context, BaseFingerprint.ExceptionListener exceptionListener) {
        super(context, exceptionListener);
        try {
            Spass spass = new Spass();
            spass.initialize(this.mContext);
            this.mSpassFingerprint = new SpassFingerprint(this.mContext);
            this.setHardwareEnable(spass.isFeatureEnabled(0));
            this.setRegisteredFingerprint(this.mSpassFingerprint.hasRegisteredFinger());
        }
        catch (Throwable e) {
            this.onCatchException(e);
        }
    }

    @Override
    protected void doIdentify() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SamsungFingerprint.this.mSpassFingerprint.startIdentify(new SpassFingerprint.IdentifyListener(){

                        public void onFinished(int i) {
                            SamsungFingerprint.this.mResultCode = i;
                        }

                        public void onReady() {
                        }

                        public void onStarted() {
                        }

                        public void onCompleted() {
                            switch (SamsungFingerprint.this.mResultCode) {
                                case 0: 
                                case 100: {
                                    SamsungFingerprint.this.onSucceed();
                                    break;
                                }
                                case 4: 
                                case 7: 
                                case 9: 
                                case 12: 
                                case 13: 
                                case 16: 
                                case 51: {
                                    SamsungFingerprint.this.onNotMatch();
                                    break;
                                }
                                case 8: {
                                    break;
                                }
                                default: {
                                    SamsungFingerprint.this.onFailed(false);
                                }
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    if (e instanceof SpassInvalidStateException) {
                        SpassInvalidStateException stateException = (SpassInvalidStateException)e;
                        if (stateException.getType() == 1) {
                            SamsungFingerprint.this.onFailed(true);
                        } else {
                            SamsungFingerprint.this.onCatchException(e);
                            SamsungFingerprint.this.onFailed(false);
                        }
                    }
                    SamsungFingerprint.this.onCatchException(e);
                    SamsungFingerprint.this.onFailed(false);
                }
            }
        });
    }

    @Override
    protected void doCancelIdentify() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SamsungFingerprint.this.mSpassFingerprint != null) {
                        SamsungFingerprint.this.mSpassFingerprint.cancelIdentify();
                    }
                }
                catch (Throwable e) {
                    SamsungFingerprint.this.onCatchException(e);
                }
            }
        });
    }
}

