/*
 * Decompiled with CFR 0.152.
 */
package com.wei.android.lib.fingerprintidentify.base;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;

public abstract class BaseFingerprint {
    protected Context mContext;
    private Handler mHandler;
    private IdentifyListener mIdentifyListener;
    private ExceptionListener mExceptionListener;
    private int mNumberOfFailures = 0;
    private int mMaxAvailableTimes = 3;
    private boolean mIsHardwareEnable = false;
    private boolean mIsRegisteredFingerprint = false;
    private boolean mIsCalledStartIdentify = false;
    private boolean mIsCanceledIdentify = false;

    public BaseFingerprint(Context context, ExceptionListener exceptionListener) {
        this.mContext = context;
        this.mExceptionListener = exceptionListener;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void startIdentify(int maxAvailableTimes, IdentifyListener identifyListener) {
        this.mMaxAvailableTimes = maxAvailableTimes;
        this.mIdentifyListener = identifyListener;
        this.mIsCalledStartIdentify = true;
        this.mIsCanceledIdentify = false;
        this.mNumberOfFailures = 0;
        this.doIdentify();
    }

    public void resumeIdentify() {
        if (this.mIsCalledStartIdentify && this.mIdentifyListener != null && this.mNumberOfFailures < this.mMaxAvailableTimes) {
            this.mIsCanceledIdentify = false;
            this.doIdentify();
        }
    }

    public void cancelIdentify() {
        this.mIsCanceledIdentify = true;
        this.doCancelIdentify();
    }

    protected abstract void doIdentify();

    protected abstract void doCancelIdentify();

    protected void onSucceed() {
        if (this.mIsCanceledIdentify) {
            return;
        }
        this.mNumberOfFailures = this.mMaxAvailableTimes;
        if (this.mIdentifyListener != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseFingerprint.this.mIdentifyListener.onSucceed();
                }
            });
        }
        this.cancelIdentify();
    }

    protected void onNotMatch() {
        if (this.mIsCanceledIdentify) {
            return;
        }
        if (++this.mNumberOfFailures < this.mMaxAvailableTimes) {
            if (this.mIdentifyListener != null) {
                final int chancesLeft = this.mMaxAvailableTimes - this.mNumberOfFailures;
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BaseFingerprint.this.mIdentifyListener.onNotMatch(chancesLeft);
                    }
                });
            }
            if (this.needToCallDoIdentifyAgainAfterNotMatch()) {
                this.doIdentify();
            }
            return;
        }
        this.onFailed(false);
    }

    protected void onFailed(final boolean isDeviceLocked) {
        if (this.mIsCanceledIdentify) {
            return;
        }
        final boolean isStartFailedByDeviceLocked = isDeviceLocked && this.mNumberOfFailures == 0;
        this.mNumberOfFailures = this.mMaxAvailableTimes;
        if (this.mIdentifyListener != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (isStartFailedByDeviceLocked) {
                        BaseFingerprint.this.mIdentifyListener.onStartFailedByDeviceLocked();
                    } else {
                        BaseFingerprint.this.mIdentifyListener.onFailed(isDeviceLocked);
                    }
                }
            });
        }
        this.cancelIdentify();
    }

    protected void onCatchException(Throwable exception) {
        if (this.mExceptionListener != null && exception != null) {
            this.mExceptionListener.onCatchException(exception);
        }
    }

    public boolean isEnable() {
        return this.mIsHardwareEnable && this.mIsRegisteredFingerprint;
    }

    public boolean isHardwareEnable() {
        return this.mIsHardwareEnable;
    }

    protected void setHardwareEnable(boolean hardwareEnable) {
        this.mIsHardwareEnable = hardwareEnable;
    }

    public boolean isRegisteredFingerprint() {
        return this.mIsRegisteredFingerprint;
    }

    protected void setRegisteredFingerprint(boolean registeredFingerprint) {
        this.mIsRegisteredFingerprint = registeredFingerprint;
    }

    protected void runOnUiThread(Runnable runnable) {
        this.mHandler.post(runnable);
    }

    protected boolean needToCallDoIdentifyAgainAfterNotMatch() {
        return true;
    }

    public static interface ExceptionListener {
        public void onCatchException(Throwable var1);
    }

    public static interface IdentifyListener {
        public void onSucceed();

        public void onNotMatch(int var1);

        public void onFailed(boolean var1);

        public void onStartFailedByDeviceLocked();
    }
}

