/*
 * Decompiled with CFR 0.152.
 */
package ua_parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ua_parser.UserAgent;

public class UserAgentParser {
    private final List<UAPattern> patterns;

    public UserAgentParser(List<UAPattern> patterns) {
        this.patterns = patterns;
    }

    public static UserAgentParser fromList(List<Map<String, String>> configList) {
        ArrayList<UAPattern> configPatterns = new ArrayList<UAPattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(UserAgentParser.patternFromMap(configMap));
        }
        return new UserAgentParser(Collections.synchronizedList(configPatterns));
    }

    public UserAgent parse(String agentString) {
        if (agentString == null) {
            return null;
        }
        for (UAPattern p : this.patterns) {
            UserAgent agent = p.match(agentString);
            if (agent == null) continue;
            return agent;
        }
        return new UserAgent("Other", null, null, null);
    }

    protected static UAPattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("User agent is missing regex");
        }
        return new UAPattern(Pattern.compile(regex), configMap.get("family_replacement"), configMap.get("v1_replacement"), configMap.get("v2_replacement"));
    }

    protected static class UAPattern {
        private final Pattern pattern;
        private final String familyReplacement;
        private final String v1Replacement;
        private final String v2Replacement;

        public UAPattern(Pattern pattern, String familyReplacement, String v1Replacement, String v2Replacement) {
            this.pattern = pattern;
            this.familyReplacement = familyReplacement;
            this.v1Replacement = v1Replacement;
            this.v2Replacement = v2Replacement;
        }

        public UserAgent match(String agentString) {
            String group2;
            String family = null;
            String v1 = null;
            String v2 = null;
            String v3 = null;
            Matcher matcher = this.pattern.matcher(agentString);
            if (!matcher.find()) {
                return null;
            }
            int groupCount = matcher.groupCount();
            if (this.familyReplacement != null) {
                family = this.familyReplacement.contains("$1") && groupCount >= 1 && matcher.group(1) != null ? this.familyReplacement.replaceFirst("\\$1", Matcher.quoteReplacement(matcher.group(1))) : this.familyReplacement;
            } else if (groupCount >= 1) {
                family = matcher.group(1);
            }
            if (this.v1Replacement != null) {
                v1 = this.v1Replacement;
            } else if (groupCount >= 2 && !this.isBlank(group2 = matcher.group(2))) {
                v1 = group2;
            }
            if (this.v2Replacement != null) {
                v2 = this.v2Replacement;
            } else if (groupCount >= 3) {
                String group4;
                String group3 = matcher.group(3);
                if (!this.isBlank(group3)) {
                    v2 = group3;
                }
                if (groupCount >= 4 && !this.isBlank(group4 = matcher.group(4))) {
                    v3 = group4;
                }
            }
            return family == null ? null : new UserAgent(family, v1, v2, v3);
        }

        private boolean isBlank(String value) {
            return value == null || value.isEmpty();
        }
    }
}

