/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.javash.autocomplete.JavaAutocomplete;
import com.twosigma.beakerx.javash.evaluator.JavaWorkerThread;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import java.io.File;

public class JavaEvaluator
extends BaseEvaluator {
    public static final String WRAPPER_CLASS_NAME = "BeakerWrapperClass1261714175";
    private final String packageId;
    private ClasspathScanner cps;
    private JavaAutocomplete jac;
    private JavaWorkerThread workerThread;

    public JavaEvaluator(String id, String sId) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("javash"), (TempFolderFactory)new TempFolderFactoryImpl());
    }

    public JavaEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory) {
        super(id, sId, cellExecutor, tempFolderFactory);
        this.packageId = "com.twosigma.beaker.javash.bkr" + this.shellId.split("-")[0];
        this.cps = new ClasspathScanner();
        this.jac = this.createJavaAutocomplete(this.cps);
        this.classPath = new Classpath();
        this.imports = new Imports();
        this.workerThread = new JavaWorkerThread(this);
        this.workerThread.start();
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath, this.outDir);
        this.cps = new ClasspathScanner(cpp);
        this.jac = this.createAutocomplete(this.imports, this.cps);
        this.workerThread.updateLoader();
        this.workerThread.halt();
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
        this.workerThread.halt();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.jac.doAutocomplete(code, caretPosition);
    }

    private JavaAutocomplete createJavaAutocomplete(ClasspathScanner c) {
        return new JavaAutocomplete(c);
    }

    private JavaAutocomplete createAutocomplete(Imports imports, ClasspathScanner cps) {
        JavaAutocomplete jac = this.createJavaAutocomplete(cps);
        for (ImportPath st : imports.getImportPaths()) {
            jac.addImport(st.asString());
        }
        return jac;
    }

    private String createClasspath(Classpath classPath, String outDir) {
        String cpp = "";
        for (String pt : classPath.getPathsAsStrings()) {
            cpp = cpp + pt;
            cpp = cpp + File.pathSeparator;
        }
        cpp = cpp + File.pathSeparator;
        cpp = cpp + outDir;
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public String getPackageId() {
        return this.packageId;
    }
}

