/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.twosigma.beakerx.table.TableDisplay;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class TableDisplayConverter {
    public static List<Map<String, Object>> convert(int rowCount, int columnCount, List<String> columnNames, TableDisplay.Element tableElement) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int r = 0; r < rowCount; ++r) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            for (int c = 0; c < columnCount; ++c) {
                String value = tableElement.get(c, r);
                String headerName = columnNames.get(c);
                if (headerName.equals("time")) {
                    entry.put(headerName, TableDisplayConverter.convertDate(value));
                    continue;
                }
                entry.put(headerName, TableDisplayConverter.convertToNumber(value));
            }
            result.add(entry);
        }
        return result;
    }

    private static Object convertToNumber(Object value) {
        if (value instanceof String && NumberUtils.isNumber((String)((String)value))) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return value;
    }

    private static Object convertDate(Object x) {
        if (x instanceof Number) {
            return x;
        }
        if (x instanceof Date) {
            Date date = (Date)x;
            return date;
        }
        if (x instanceof String) {
            Date inputDate = null;
            try {
                inputDate = new SimpleDateFormat("yyyy-MM-dd").parse((String)x);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("time column accepts String date in a following format yyyy-MM-dd");
            }
            return inputDate;
        }
        throw new IllegalArgumentException("time column accepts numbers or java.util.Date objects or String date in a following format yyyy-MM-dd");
    }
}

