/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.threads;

import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.SocketEnum;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.kernel.msg.MessageHolder;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResultSender
implements Observer {
    public static Logger logger = LoggerFactory.getLogger(ExecutionResultSender.class);
    private MessageCreator handler;
    private volatile boolean work = true;
    private KernelFunctionality kernel;

    public ExecutionResultSender(KernelFunctionality kernel) {
        this.kernel = kernel;
        this.handler = new MessageCreator(kernel);
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        SimpleEvaluationObject seo = (SimpleEvaluationObject)o;
        if (seo != null) {
            Iterator<MessageHolder> iterator = this.handler.createMessage(seo).iterator();
            while (this.work && iterator.hasNext()) {
                MessageHolder job = iterator.next();
                if (this.handler == null || job == null) continue;
                if (SocketEnum.IOPUB_SOCKET.equals((Object)job.getSocketType())) {
                    this.kernel.publish(job.getMessage());
                    continue;
                }
                if (!SocketEnum.SHELL_SOCKET.equals((Object)job.getSocketType())) continue;
                this.kernel.send(job.getMessage());
            }
        }
    }

    public void exit() {
        this.work = false;
    }
}

