/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.commands;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.CodeWithoutCommand;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelParameters;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.commands.MagicCommandFinder;
import com.twosigma.beakerx.kernel.commands.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.commands.MagicCommandResult;
import com.twosigma.beakerx.kernel.commands.MavenJarResolver;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandItem;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandItemWithCode;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandItemWithReply;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandItemWithResult;
import com.twosigma.beakerx.kernel.commands.item.MagicCommandItemWithResultAndCode;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.text.StrMatcher;
import org.apache.commons.text.StrTokenizer;

public class MagicCommand {
    public static final String JAVASCRIPT = "%%javascript";
    public static final String HTML = "%%html";
    public static final String BASH = "%%bash";
    public static final String LSMAGIC = "%lsmagic";
    public static final String CLASSPATH = "%classpath";
    public static final String CLASSPATH_ADD_JAR = "%classpath add jar";
    public static final String CLASSPATH_REMOVE = "%classpath remove";
    public static final String CLASSPATH_SHOW = "%classpath";
    public static final String CLASSPATH_ADD_MVN = "%classpath add mvn";
    public static final String ADD_MVN_FORMAT_ERROR_MESSAGE = "Wrong command format, should be %classpath add mvn group name version";
    public static final String IMPORT = "%import";
    public static final String ADD_STATIC_IMPORT = "%import static";
    public static final String UNIMPORT = "%unimport";
    public static final String DEFAULT_DATASOURCE = "%defaultDatasource";
    public static final String TIME_LINE = "%time";
    public static final String TIME_CELL = "%%time";
    public static final String TIMEIT_LINE = "%timeit";
    public static final String TIMEIT_CELL = "%%timeit";
    public static final String DATASOURCES = "%datasources";
    public static final String USAGE_ERROR_MSG = "UsageError: %s is a cell magic, but the cell body is empty.";
    public static final String WRONG_FORMAT_MSG = "Wrong format. ";
    private MessageCreator messageCreator;
    private KernelFunctionality kernel;

    public MagicCommand(KernelFunctionality kernel) {
        this.kernel = (KernelFunctionality)Preconditions.checkNotNull((Object)kernel);
        this.messageCreator = new MessageCreator(this.kernel);
    }

    public MagicCommandResult process(Code code, Message message, int executionCount) {
        MagicCommandFinder finder = MagicCommandFinder.find(code, this.kernel.getMagicCommands(), message, executionCount, this.messageCreator);
        MagicCommandResult result = new MagicCommandResult();
        if (finder.hasErrors()) {
            finder.getErrors().forEach(result::addItem);
        } else {
            List<String> functionalitiesToRun = finder.getCommands();
            functionalitiesToRun.forEach(item -> {
                MagicCommandItem magicCommandResultItem = finder.get((String)item).process(code, (String)item, message, executionCount);
                result.addItem(magicCommandResultItem);
            });
        }
        return result;
    }

    public MagicCommandFunctionality defaultDataSources() {
        return this.dataSource(DEFAULT_DATASOURCE);
    }

    public MagicCommandFunctionality dataSources() {
        return this.dataSource(DATASOURCES);
    }

    private MagicCommandFunctionality dataSource(String source) {
        return (code, command, message, executionCount) -> {
            String[] parts = command.split(" ");
            if (parts.length != 2) {
                return this.sendErrorMessage(message, WRONG_FORMAT_MSG, executionCount);
            }
            if (!parts[1].contains("jdbc:")) {
                return this.sendErrorMessage(message, "Incorrect jdbc url.", executionCount);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(source, parts[1]);
            this.kernel.setShellOptions(new KernelParameters(params));
            return this.getMagicCommandItem(code, message, executionCount);
        };
    }

    public MagicCommandFunctionality addStaticImport() {
        return (code, command, message, executionCount) -> {
            String[] parts = command.split(" ");
            if (parts.length != 3) {
                this.sendErrorMessage(message, WRONG_FORMAT_MSG, executionCount);
            }
            this.kernel.addImport(new ImportPath(parts[1] + " " + parts[2]));
            return this.getMagicCommandItem(code, message, executionCount);
        };
    }

    public MagicCommandFunctionality addImport() {
        return (code, command, message, executionCount) -> {
            String[] parts = command.split(" ");
            if (parts.length != 2) {
                return this.createResultWithCustomMessage(this.kernel.getImports().toString(), message, executionCount);
            }
            this.kernel.addImport(new ImportPath(parts[1]));
            if (this.isValidImport(parts[1], executionCount)) {
                return this.getMagicCommandItem(code, message, executionCount);
            }
            this.kernel.removeImport(new ImportPath(parts[1]));
            return this.sendErrorMessage(message, "Could not import " + parts[1] + ", class not found.", executionCount);
        };
    }

    private boolean isValidImport(String part, int executionCount) {
        try {
            CompletableFuture validImportFuture = new CompletableFuture();
            this.kernel.executeCode("", new Message(), executionCount, seo -> validImportFuture.complete(!seo.getStatus().equals((Object)SimpleEvaluationObject.EvaluationStatus.ERROR)));
            return (Boolean)validImportFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return Boolean.FALSE;
        }
    }

    private MagicCommandItem createResultWithCustomMessage(String customMessage, Message message, int executionCount) {
        return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, customMessage, false), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
    }

    public MagicCommandFunctionality unimport() {
        return (code, command, message, executionCount) -> {
            String[] parts = command.split(" ");
            if (parts.length != 2) {
                return this.sendErrorMessage(message, WRONG_FORMAT_MSG, executionCount);
            }
            this.kernel.removeImport(new ImportPath(parts[1]));
            return this.getMagicCommandItem(code, message, executionCount);
        };
    }

    public MagicCommandFunctionality classpathShow() {
        return (code, command, message, executionCount) -> {
            MIMEContainer result = MIMEContainer.Text(this.kernel.getClasspath());
            if (code.takeCodeWithoutCommand().isPresent()) {
                return new MagicCommandItemWithResultAndCode(this.messageCreator.buildOutputMessage(message, result.getData().toString(), false), this.messageCreator.buildReplyWithoutStatus(message, executionCount), code.takeCodeWithoutCommand().get());
            }
            return this.createResultWithCustomMessage(result.getData().toString(), message, executionCount);
        };
    }

    public MagicCommandFunctionality classpathRemove() {
        return (code, command, message, executionCount) -> null;
    }

    public MagicCommandFunctionality classpathAddJar() {
        return (code, command, message, executionCount) -> {
            String[] split = this.splitPath(command);
            if (split.length != 4) {
                return this.sendErrorMessage(message, "Wrong format. %classpath add jar", executionCount);
            }
            String path = split[3];
            ErrorData errorData = this.isValidPath(path);
            if (errorData.hasError()) {
                return this.sendErrorMessage(message, errorData.getMessage(), executionCount);
            }
            return this.getMagicCommandItem(this.addJars(path), code, message, executionCount);
        };
    }

    public MagicCommandFunctionality classpathAddMvn(MavenJarResolver.ResolverParams commandParams) {
        return (code, command, message, executionCount) -> {
            String[] split = this.splitPath(command);
            if (split.length != 6) {
                return this.sendErrorMessage(message, ADD_MVN_FORMAT_ERROR_MESSAGE, executionCount);
            }
            MavenJarResolver classpathAddMvnCommand = new MavenJarResolver(commandParams);
            MavenJarResolver.AddMvnCommandResult result = classpathAddMvnCommand.retrieve(split[3], split[4], split[5]);
            if (result.isJarRetrieved()) {
                return this.getMagicCommandItem(this.addJars(classpathAddMvnCommand.getPathToMavenRepo() + "/*"), code, message, executionCount);
            }
            return this.sendErrorMessage(message, result.getErrorMessage(), executionCount);
        };
    }

    private String[] splitPath(String command) {
        StrTokenizer tokenizer = new StrTokenizer(command, StrMatcher.spaceMatcher(), StrMatcher.quoteMatcher());
        return tokenizer.getTokenArray();
    }

    private MagicCommandItemWithResult sendErrorMessage(Message message, String messageText, int executionCount) {
        return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, messageText, true), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
    }

    private Collection<String> addJars(String path) {
        LinkedList addedJarsName = Lists.newLinkedList();
        if (this.doesPathContainsWildCards(path).booleanValue()) {
            Map<Path, String> paths = this.getPaths(path);
            List<PathToJar> pathsToJars = paths.keySet().stream().map(currentPath -> new PathToJar(currentPath.toString())).collect(Collectors.toList());
            List<Path> addedPaths = this.kernel.addJarsToClasspath(pathsToJars);
            addedJarsName.addAll(addedPaths.stream().map(x -> x.getFileName().toString()).collect(Collectors.toList()));
        } else {
            Path currentPath2 = Paths.get(path, new String[0]);
            if (this.kernel.addJarToClasspath(new PathToJar(path))) {
                addedJarsName.add(currentPath2.getFileName().toString());
            }
        }
        return addedJarsName;
    }

    private Boolean containsSingleWildcardSymbol(String path) {
        return path.length() - path.replace("*", "").length() == 1;
    }

    private Map<Path, String> getPaths(String pathWithWildcard) {
        String pathWithoutWildcards = pathWithWildcard.replace("*", "");
        try {
            return Files.list(Paths.get(pathWithoutWildcards, new String[0])).filter(path -> path.toString().toLowerCase().endsWith(".jar")).collect(Collectors.toMap(p -> p, o -> o.getFileName().toString()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find any jars files in selected path");
        }
    }

    private Boolean doesPathContainsWildCards(String path) {
        return path.contains("*");
    }

    private MagicCommandItem getMagicCommandItem(Collection<String> newAddedJars, Code code, Message message, int executionCount) {
        if (newAddedJars.isEmpty()) {
            return this.getMagicCommandItem(code, message, executionCount);
        }
        String textMessage = "Added jar" + (newAddedJars.size() > 1 ? "s: " : ": ") + newAddedJars + "\n";
        if (code.takeCodeWithoutCommand().isPresent()) {
            return new MagicCommandItemWithResultAndCode(this.messageCreator.buildOutputMessage(message, textMessage, false), this.messageCreator.buildReplyWithoutStatus(message, executionCount), code.takeCodeWithoutCommand().get());
        }
        return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, textMessage, false), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
    }

    private MagicCommandItem getMagicCommandItem(Code code, Message message, int executionCount) {
        if (code.takeCodeWithoutCommand().isPresent()) {
            return new MagicCommandItemWithCode(code.takeCodeWithoutCommand().get());
        }
        return new MagicCommandItemWithReply(this.messageCreator.buildReplyWithoutStatus(message, executionCount));
    }

    public MagicCommandFunctionality javascript() {
        return (code, command, message, executionCount) -> {
            MIMEContainer result = MIMEContainer.JavaScript(code.takeCodeWithoutCommand().get().asString());
            return new MagicCommandItemWithResult(this.messageCreator.buildMessage(message, Collections.singletonList(result), executionCount), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
        };
    }

    public MagicCommandFunctionality html() {
        return (code, command, message, executionCount) -> code.takeCodeWithoutCommand().map(codeWithoutCommand -> {
            MIMEContainer html = MIMEContainer.HTML("<html>" + codeWithoutCommand.asString() + "</html>");
            return new MagicCommandItemWithResult(this.messageCreator.buildMessage(message, Collections.singletonList(html), executionCount), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
        }).orElse(this.sendErrorMessage(message, String.format(USAGE_ERROR_MSG, HTML), executionCount));
    }

    public MagicCommandFunctionality bash() {
        return (code, command, message, executionCount) -> code.takeCodeWithoutCommand().map(codeWithoutCommand -> {
            ErrorData errorData = this.executeBashCode((CodeWithoutCommand)codeWithoutCommand);
            if (errorData.hasError()) {
                return this.sendErrorMessage(message, errorData.getMessage(), executionCount);
            }
            return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, errorData.getMessage(), false), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
        }).orElse(this.sendErrorMessage(message, String.format(USAGE_ERROR_MSG, BASH), executionCount));
    }

    public MagicCommandFunctionality lsmagic() {
        return (code, command, message, executionCount) -> {
            String result = "Available magic commands:\n";
            result = result + this.kernel.getMagicCommands().stream().map(commandType -> commandType.getCommand() + " " + commandType.getParameters()).collect(Collectors.joining("\n"));
            return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, result, false), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
        };
    }

    public MagicCommandFunctionality timeLineMode() {
        return (code, command, message, executionCount) -> {
            String codeToExecute = code.asString().replace(TIME_LINE, "");
            return this.time(codeToExecute, message, executionCount);
        };
    }

    public MagicCommandFunctionality timeCellMode() {
        return (code, command, message, executionCount) -> this.time(code.takeCodeWithoutCommand().get().asString(), message, executionCount);
    }

    public MagicCommandItemWithResult time(String codeToExecute, Message message, int executionCount) {
        CompletableFuture compileTime = new CompletableFuture();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long currentThreadId = Thread.currentThread().getId();
        Long startWallTime = System.nanoTime();
        Long startCpuTotalTime = threadMXBean.getCurrentThreadCpuTime();
        Long startUserTime = threadMXBean.getCurrentThreadUserTime();
        this.kernel.executeCode(codeToExecute, message, executionCount, seo -> {
            Long endWallTime = System.nanoTime();
            Long endCpuTotalTime = threadMXBean.getThreadCpuTime(currentThreadId);
            Long endUserTime = threadMXBean.getThreadUserTime(currentThreadId);
            compileTime.complete(new TimeMeasureData(endCpuTotalTime - startCpuTotalTime, endUserTime - startUserTime, endWallTime - startWallTime));
        });
        String messageInfo = "CPU times: user %s, sys: %s, total: %s \nWall Time: %s\n";
        try {
            TimeMeasureData timeMeasuredData = (TimeMeasureData)compileTime.get();
            return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, String.format(messageInfo, this.format(timeMeasuredData.getCpuUserTime()), this.format(timeMeasuredData.getCpuTotalTime() - timeMeasuredData.getCpuUserTime()), this.format(timeMeasuredData.getCpuTotalTime()), this.format(timeMeasuredData.getWallTime())), false), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
        }
        catch (InterruptedException | ExecutionException e) {
            return this.sendErrorMessage(message, "There occurs problem during measuring time for your statement.", executionCount);
        }
    }

    private Options createForTimeIt() {
        Options options = new Options();
        options.addOption("n", true, "Execute the given statement <N> times in a loop");
        options.addOption("r", true, "Repeat the loop iteration <R> times and take the best result. Default: 3");
        options.addOption("q", false, "Quiet, do not print result.");
        return options;
    }

    public MagicCommandFunctionality timeItLineMode() {
        return (code, command, message, executionCount) -> {
            String codeToExecute = code.asString().replace(TIMEIT_LINE, "");
            codeToExecute = codeToExecute.replaceAll("(-.)(\\d*\\s)", "");
            try {
                return this.timeIt(this.buildTimeItOption(code), codeToExecute, message, executionCount);
            }
            catch (IllegalArgumentException e) {
                return this.sendErrorMessage(message, e.getMessage(), executionCount);
            }
        };
    }

    public MagicCommandFunctionality timeItCellMode() {
        return (code, command, message, executionCount) -> {
            try {
                return this.timeIt(this.buildTimeItOption(code), code.takeCodeWithoutCommand().get().asString(), message, executionCount);
            }
            catch (IllegalArgumentException e) {
                return this.sendErrorMessage(message, e.getMessage(), executionCount);
            }
        };
    }

    private TimeItOption buildTimeItOption(Code code) {
        TimeItOption timeItOption = new TimeItOption();
        try {
            StrTokenizer tokenizer = new StrTokenizer(code.asString());
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.createForTimeIt(), tokenizer.getTokenArray());
            if (cmd.hasOption('n')) {
                timeItOption.setNumber(Integer.valueOf(cmd.getOptionValue('n')));
            }
            if (cmd.hasOption('r')) {
                timeItOption.setRepeat(Integer.valueOf(cmd.getOptionValue('r')));
            }
            if (cmd.hasOption('q')) {
                timeItOption.setQuietMode(true);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected value must be a number " + e.getMessage().toLowerCase());
        }
        return timeItOption;
    }

    public MagicCommandItemWithResult timeIt(TimeItOption timeItOption, String codeToExecute, Message message, int executionCount) {
        int number;
        String output = "%s \u00b1 %s per loop (mean \u00b1 std. dev. of %d run, %d loop each)";
        if (timeItOption.getNumber() < 0) {
            return this.sendErrorMessage(message, "Number of execution must be bigger then 0", executionCount);
        }
        int n = number = timeItOption.getNumber() == 0 ? this.getBestNumber(codeToExecute) : timeItOption.getNumber().intValue();
        if (timeItOption.getRepeat() == 0) {
            return this.sendErrorMessage(message, "Repeat value must be bigger then 0", executionCount);
        }
        CompletableFuture isStatementsCorrect = new CompletableFuture();
        this.kernel.executeCodeWithTimeMeasurement(codeToExecute, message, executionCount, executeCodeCallbackWithTime -> {
            if (executeCodeCallbackWithTime.getStatus().equals((Object)SimpleEvaluationObject.EvaluationStatus.ERROR)) {
                isStatementsCorrect.complete(false);
            } else {
                isStatementsCorrect.complete(true);
            }
        });
        try {
            if (!((Boolean)isStatementsCorrect.get()).booleanValue()) {
                return this.sendErrorMessage(message, "Please correct your statement", executionCount);
            }
            ArrayList allRuns = new ArrayList();
            ArrayList timings = new ArrayList();
            CompletableFuture isReady = new CompletableFuture();
            IntStream.range(0, timeItOption.getRepeat()).forEach(repeatIter -> IntStream.range(0, number).forEach(numberIter -> this.kernel.executeCodeWithTimeMeasurement(codeToExecute, message, executionCount, executeCodeCallbackWithTime -> {
                allRuns.add(executeCodeCallbackWithTime.getPeriodOfEvaluationInNanoseconds());
                if (repeatIter == timeItOption.getRepeat() - 1 && numberIter == number - 1) {
                    isReady.complete(true);
                }
            })));
            if (((Boolean)isReady.get()).booleanValue()) {
                allRuns.forEach(run -> timings.add(run / (long)number));
                long average = timings.stream().reduce((aLong, aLong2) -> aLong + aLong2).orElse(0L) / (long)timings.size();
                double stdev = Math.pow(timings.stream().map(currentValue -> Math.pow(currentValue - average, 2.0)).reduce((aDouble, aDouble2) -> aDouble + aDouble2).orElse(0.0) / (double)timings.size(), 0.5);
                output = timeItOption.getQuietMode() != false ? "" : String.format(output, this.format(average), this.format((long)stdev), timeItOption.getRepeat(), number);
                return new MagicCommandItemWithResult(this.messageCreator.buildOutputMessage(message, output, false), this.messageCreator.buildReplyWithoutStatus(message, executionCount));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return this.sendErrorMessage(message, "There occurs problem with " + e.getMessage(), executionCount);
        }
        return this.sendErrorMessage(message, "There occurs problem with timeIt operations", executionCount);
    }

    private int getBestNumber(String codeToExecute) {
        for (int value = 0; value < 10; ++value) {
            Double numberOfExecution = Math.pow(10.0, value);
            CompletableFuture keepLooking = new CompletableFuture();
            Long startTime = System.nanoTime();
            IntStream.range(0, numberOfExecution.intValue()).forEach(indexOfExecution -> this.kernel.executeCode(codeToExecute, new Message(), 0, seo -> {
                if (numberOfExecution.intValue() - 1 == indexOfExecution) {
                    if ((double)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) > 0.2) {
                        keepLooking.complete(false);
                    } else {
                        keepLooking.complete(true);
                    }
                }
            }));
            try {
                if (((Boolean)keepLooking.get()).booleanValue()) {
                    continue;
                }
                return numberOfExecution.intValue();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException("Cannot find best number of execution.");
            }
        }
        throw new IllegalStateException("Cannot find best number of execution.");
    }

    private String format(Long nanoSeconds) {
        if (nanoSeconds < 1000L) {
            return nanoSeconds + " ns";
        }
        if (nanoSeconds >= 1000L && nanoSeconds < 1000000L) {
            return TimeUnit.NANOSECONDS.toMicros(nanoSeconds) + " \u00b5s";
        }
        if (nanoSeconds > 1000000L && nanoSeconds < 1000000000L) {
            return TimeUnit.NANOSECONDS.toMillis(nanoSeconds) + " ms";
        }
        return TimeUnit.NANOSECONDS.toSeconds(nanoSeconds) + " s";
    }

    private ErrorData executeBashCode(CodeWithoutCommand code) {
        String[] cmd = new String[]{"/bin/bash", "-c", code.asString()};
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process process = pb.start();
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            process.destroy();
        }
        catch (IOException | InterruptedException e) {
            return new ErrorData(true, e.getMessage());
        }
        return new ErrorData(false, output.toString());
    }

    private ErrorData isValidPath(String path) {
        boolean isEmpty = ((String)Preconditions.checkNotNull((Object)path)).isEmpty();
        if (isEmpty) {
            return new ErrorData(true, "Please provide a path");
        }
        if (this.doesPathContainsWildCards(path).booleanValue()) {
            if (!this.containsSingleWildcardSymbol(path).booleanValue() || !path.endsWith("*")) {
                return new ErrorData(true, "Bad classpath wildcard syntax, path can only end with *");
            }
            if (!Paths.get(path.replace("*", ""), new String[0]).toFile().exists()) {
                return new ErrorData(true, "Bad classpath, directory cannot be find");
            }
        } else if (!Paths.get(path, new String[0]).toFile().exists()) {
            return new ErrorData(true, "Bad classpath, file not found");
        }
        return new ErrorData(false, "");
    }

    private class TimeItOption {
        Integer number = 0;
        Integer repeat = 3;
        Boolean quietMode = false;

        public void setNumber(Integer number) {
            this.number = number;
        }

        public void setRepeat(Integer repeat) {
            this.repeat = repeat;
        }

        public void setQuietMode(Boolean quietMode) {
            this.quietMode = quietMode;
        }

        public Integer getNumber() {
            return this.number;
        }

        public Integer getRepeat() {
            return this.repeat;
        }

        public Boolean getQuietMode() {
            return this.quietMode;
        }
    }

    private class ErrorData {
        boolean error;
        String message;

        public ErrorData(boolean hasError, String message) {
            this.error = hasError;
            this.message = message;
        }

        public boolean hasError() {
            return this.error;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private class TimeMeasureData {
        private Long cpuTotalTime;
        private Long cpuUserTime;
        private Long wallTime;

        public TimeMeasureData(Long cpuTotalTime, Long cpuUserTime, Long wallTime) {
            this.cpuTotalTime = cpuTotalTime;
            this.cpuUserTime = cpuUserTime;
            this.wallTime = wallTime;
        }

        public Long getCpuTotalTime() {
            return this.cpuTotalTime;
        }

        public Long getCpuUserTime() {
            return this.cpuUserTime;
        }

        public Long getWallTime() {
            return this.wallTime;
        }
    }
}

