/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Comm {
    private static final Logger logger = LoggerFactory.getLogger(Comm.class);
    public static final String METHOD = "method";
    public static final String UPDATE = "update";
    public static final String STATE = "state";
    public static final String VERSION = "version";
    public static final String COMM_ID = "comm_id";
    public static final String TARGET_NAME = "target_name";
    public static final String DATA = "data";
    public static final String METADATA = "metadata";
    public static final String TARGET_MODULE = "target_module";
    public static final String COMMS = "comms";
    public static final String BUFFER_PATHS = "buffer_paths";
    private String commId;
    private String targetName;
    private HashMap<?, ?> data;
    private HashMap<?, ?> metadata;
    private String targetModule;
    private KernelFunctionality kernel;
    private List<Handler<Message>> msgCallbackList = new ArrayList<Handler<Message>>();
    private List<Handler<Message>> closeCallbackList = new ArrayList<Handler<Message>>();

    public Comm(String commId, String targetName) {
        this.kernel = KernelManager.get();
        this.commId = commId;
        this.targetName = targetName;
        this.data = new HashMap();
        this.metadata = new HashMap();
    }

    public Comm(String commId, TargetNamesEnum targetName) {
        this(commId, targetName.getTargetName());
    }

    public Comm(TargetNamesEnum targetName) {
        this(Utils.uuid(), targetName.getTargetName());
    }

    public Comm(String targetName) {
        this(Utils.uuid(), targetName);
    }

    public String getCommId() {
        return this.commId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public HashMap<?, ?> getData() {
        return this.data;
    }

    public void setData(HashMap<?, ?> data) {
        this.data = data;
    }

    public void setMetaData(HashMap<?, ?> metadata) {
        this.metadata = metadata;
    }

    public String getTargetModule() {
        return this.targetModule;
    }

    public void setTargetModule(String targetModule) {
        this.targetModule = targetModule;
    }

    public void addMsgCallbackList(Handler<Message> ... handlers) {
        this.msgCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearMsgCallbackList() {
        this.msgCallbackList = new ArrayList<Handler<Message>>();
    }

    public List<Handler<Message>> getCloseCallbackList() {
        return this.closeCallbackList;
    }

    public void addCloseCallbackList(Handler<Message> ... handlers) {
        this.closeCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearCloseCallbackList() {
        this.closeCallbackList = new ArrayList<Handler<Message>>();
    }

    public void open() {
        Message parentMessage = this.getParentMessage();
        Message message = new Message();
        message.setHeader(new Header(JupyterMessages.COMM_OPEN, parentMessage != null ? parentMessage.getHeader().getSession() : null));
        if (parentMessage != null) {
            message.setParentHeader(this.getParentMessage().getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(TARGET_NAME, (Serializable)((Object)this.getTargetName()));
        HashMap<String, Serializable> state = new HashMap<String, Serializable>();
        state.put(STATE, this.data);
        state.put(METHOD, (Serializable)this.data.get(METHOD));
        map.put(DATA, state);
        map.put(METADATA, this.metadata);
        map.put(TARGET_MODULE, (Serializable)((Object)this.getTargetModule()));
        message.setContent(map);
        message.setMetadata(this.buildMetadata());
        this.kernel.publish(message);
        this.kernel.addComm(this.getCommId(), this);
    }

    public void close() {
        Message parentMessage = this.getParentMessage();
        if (this.getCloseCallbackList() != null && !this.getCloseCallbackList().isEmpty()) {
            for (Handler<Message> handler : this.getCloseCallbackList()) {
                handler.handle(parentMessage);
            }
        }
        Message message = new Message();
        message.setHeader(new Header(JupyterMessages.COMM_CLOSE, parentMessage != null ? parentMessage.getHeader().getSession() : null));
        if (parentMessage != null) {
            message.setParentHeader(parentMessage.getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(DATA, new HashMap());
        map.put(METADATA, new HashMap());
        message.setContent(map);
        message.setMetadata(this.buildMetadata());
        this.kernel.removeComm(this.getCommId());
        this.kernel.publish(message);
    }

    public void send() {
        this.send(JupyterMessages.COMM_MSG);
    }

    public void send(JupyterMessages type) {
        Message parentMessage = this.getParentMessage();
        Message message = new Message();
        message.setHeader(new Header(type, parentMessage != null ? parentMessage.getHeader().getSession() : null));
        if (parentMessage != null) {
            message.setParentHeader(this.getParentMessage().getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(DATA, this.data);
        map.put(METADATA, this.metadata);
        message.setContent(map);
        message.setMetadata(this.buildMetadata());
        this.kernel.publish(message);
    }

    public void sendUpdate(String propertyName, Object value) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(METHOD, UPDATE);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(propertyName, value);
        content.put(STATE, state);
        content.put(BUFFER_PATHS, new HashMap());
        this.setData(content);
        this.send();
    }

    private Message getParentMessage() {
        return InternalVariable.getParentHeader();
    }

    public void handleMsg(Message parentMessage) {
        for (Handler<Message> handler : this.msgCallbackList) {
            handler.handle(parentMessage);
        }
    }

    private HashMap<String, Serializable> buildMetadata() {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        metadata.put(VERSION, (Serializable)((Object)"2"));
        return metadata;
    }

    public String toString() {
        return this.commId + "/" + this.targetName + "/" + (this.targetModule != null && !this.targetModule.isEmpty() ? this.targetModule : "");
    }
}

