/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.kernel.CodeWithoutCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Code {
    public static final String MAGIC_COMMAND_PREFIX = "%";
    private String code;
    private List<String> commands = new ArrayList<String>();
    private String codeWithoutCommands = null;

    public Code(String code) {
        this.code = code;
        if (this.isaMagicCommand()) {
            this.setupCommandsAndCode();
        } else {
            this.codeWithoutCommands = this.code;
        }
    }

    public String asString() {
        return this.code;
    }

    public boolean isaMagicCommand() {
        return this.code.startsWith(MAGIC_COMMAND_PREFIX);
    }

    public List<String> getCommands() {
        if (!this.commands.isEmpty()) {
            return this.commands;
        }
        throw new RuntimeException("The code does not have magic command.");
    }

    public Optional<CodeWithoutCommand> takeCodeWithoutCommand() {
        if (this.codeWithoutCommands != null) {
            return Optional.of(new CodeWithoutCommand(this.codeWithoutCommands));
        }
        return Optional.empty();
    }

    private void setupCommandsAndCode() {
        Scanner scanner = new Scanner(this.code);
        this.commands = this.commands(scanner);
        String codeToExecute = StringUtils.join(this.restOfTheCode(scanner), (String)System.lineSeparator());
        if (!codeToExecute.isEmpty()) {
            this.codeWithoutCommands = codeToExecute;
        }
    }

    private List<String> restOfTheCode(Scanner scanner) {
        ArrayList<String> codeWithoutCommands = new ArrayList<String>();
        while (scanner.hasNext()) {
            codeWithoutCommands.add(scanner.nextLine());
        }
        return codeWithoutCommands;
    }

    private List<String> commands(Scanner scanner) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("^%.*", 8);
        while (scanner.hasNext(p)) {
            result.add(scanner.nextLine());
        }
        return result;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

