/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.evaluator;

import com.google.common.collect.Lists;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.KernelParameters;
import com.twosigma.beakerx.kernel.PathToJar;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class BaseEvaluator
implements Evaluator {
    public static String INTERUPTED_MSG = "interrupted";
    protected final String shellId;
    protected final String sessionId;
    protected String outDir;
    protected Classpath classPath;
    protected Imports imports;
    private final CellExecutor executor;
    protected Path tempFolder;

    public BaseEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory) {
        this.shellId = id;
        this.sessionId = sId;
        this.executor = cellExecutor;
        this.tempFolder = tempFolderFactory.createTempFolder();
        this.outDir = this.tempFolder.toString();
        this.classPath = new Classpath();
        this.imports = new Imports();
    }

    @Override
    public boolean addJarToClasspath(PathToJar path) {
        boolean added = this.addJar(path);
        if (added) {
            this.resetEnvironment();
        }
        return added;
    }

    @Override
    public List<Path> addJarsToClasspath(List<PathToJar> paths) {
        LinkedList addedPaths = Lists.newLinkedList();
        paths.forEach(path -> {
            if (this.addJar((PathToJar)path)) {
                addedPaths.add(Paths.get(path.getPath(), new String[0]));
            }
        });
        if (!addedPaths.isEmpty()) {
            this.resetEnvironment();
        }
        return addedPaths;
    }

    @Override
    public void addImport(ImportPath anImport) {
        if (this.addImportPath(anImport)) {
            this.resetEnvironment();
        }
    }

    @Override
    public void removeImport(ImportPath anImport) {
        if (this.removeImportPath(anImport)) {
            this.resetEnvironment();
        }
    }

    @Override
    public Classpath getClasspath() {
        return this.classPath;
    }

    @Override
    public Imports getImports() {
        return this.imports;
    }

    protected boolean addJar(PathToJar path) {
        return this.classPath.add(path);
    }

    protected boolean addImportPath(ImportPath anImport) {
        return this.imports.add(anImport);
    }

    protected boolean removeImportPath(ImportPath anImport) {
        return this.imports.remove(anImport);
    }

    protected void configure(KernelParameters kernelParameters) {
        Map<String, Object> params = kernelParameters.getParams();
        Collection listOfClassPath = (Collection)params.get("classpath");
        Collection listOfImports = (Collection)params.get("imports");
        if (listOfClassPath == null || listOfClassPath.isEmpty()) {
            this.classPath = new Classpath();
        } else {
            for (String line : listOfClassPath) {
                if (line.trim().isEmpty()) continue;
                this.addJar(new PathToJar(line));
            }
        }
        if (listOfImports == null || listOfImports.isEmpty()) {
            this.imports = new Imports();
        } else {
            for (String line : listOfImports) {
                if (line.trim().isEmpty()) continue;
                this.addImportPath(new ImportPath(line));
            }
        }
    }

    @Override
    public void setShellOptions(KernelParameters kernelParameters) throws IOException {
        this.configure(kernelParameters);
        this.resetEnvironment();
    }

    @Override
    public void initKernel(KernelParameters kernelParameters) {
        this.configure(kernelParameters);
    }

    public boolean executeTask(Runnable codeRunner) {
        return this.executor.executeTask(codeRunner);
    }

    @Override
    public void killAllThreads() {
        this.executor.killAllThreads();
    }

    @Override
    public void cancelExecution() {
        this.executor.cancelExecution();
    }

    @Override
    public void resetEnvironment() {
        this.executor.killAllThreads();
        this.doResetEnvironment();
    }

    protected abstract void doResetEnvironment();

    public String getSessionId() {
        return this.sessionId;
    }

    public String getOutDir() {
        return this.outDir;
    }

    @Override
    public Path getTempFolder() {
        return this.tempFolder;
    }

    @Override
    public void exit() {
        this.removeTempFolder();
    }

    private void removeTempFolder() {
        try {
            FileUtils.deleteQuietly((File)new File(this.getTempFolder().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

