/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.treemap.util;

import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.treemap.TreeMap;
import com.twosigma.beakerx.chart.treemap.util.ColorProvider;
import com.twosigma.beakerx.chart.treemap.util.ColorUtils;
import net.sf.jtreemap.swing.TreeMapNode;

public class GradientColorProvider
extends ColorProvider {
    private java.awt.Color start;
    private java.awt.Color end;

    public GradientColorProvider(TreeMap treeMap, Color start, Color end) {
        this.valueAccessor = treeMap.getValueAccessor();
        this.start = new java.awt.Color(start.getRGB());
        this.end = new java.awt.Color(end.getRGB());
        this.setValues(treeMap.getRoot());
    }

    public GradientColorProvider(TreeMap treeMap) {
        this(treeMap, Color.RED, Color.GREEN);
    }

    @Override
    public Color getColor(TreeMapNode node) {
        double value = this.getValue(node);
        float result = (float)((value - this.minValue) / (this.maxValue - this.minValue));
        return ColorUtils.interpolateColor(this.start, this.end, result);
    }
}

