/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.twosigma.beakerx.chart.Chart;
import com.twosigma.beakerx.chart.serializer.ObservableChartSerializer;
import java.io.IOException;

public abstract class ChartSerializer<T extends Chart>
extends ObservableChartSerializer<T> {
    public static final String CHART_TITLE = "chart_title";
    public static final String LEGEND_POSITION = "legend_position";
    public static final String SHOW_LEGEND = "show_legend";
    public static final String USE_TOOL_TIP = "use_tool_tip";
    public static final String INIT_WIDTH = "init_width";
    public static final String INIT_HEIGHT = "init_height";
    public static final String CUSTOM_STYLES = "custom_styles";
    public static final String LEGEND_LAYOUT = "legend_layout";
    public static final String ELEMENT_STYLES = "element_styles";

    @Override
    protected void serialize(T chart, JsonGenerator jgen) throws IOException {
        super.serialize(chart, jgen);
        String type = chart.getClass().getSimpleName();
        if ("SimpleTimePlot".equals(type)) {
            jgen.writeObjectField("type", (Object)"TimePlot");
        } else {
            jgen.writeObjectField("type", (Object)type);
        }
        jgen.writeObjectField(INIT_WIDTH, (Object)((Chart)chart).getInitWidth());
        jgen.writeObjectField(INIT_HEIGHT, (Object)((Chart)chart).getInitHeight());
        jgen.writeObjectField(CHART_TITLE, (Object)((Chart)chart).getTitle());
        jgen.writeObjectField(SHOW_LEGEND, (Object)((Chart)chart).getShowLegend());
        jgen.writeObjectField(USE_TOOL_TIP, (Object)((Chart)chart).getUseToolTip());
        jgen.writeObjectField(LEGEND_POSITION, (Object)((Chart)chart).getLegendPosition());
        jgen.writeObjectField(LEGEND_LAYOUT, (Object)((Chart)chart).getLegendLayout());
        jgen.writeObjectField(CUSTOM_STYLES, ((Chart)chart).getCustomStyles());
        jgen.writeObjectField(ELEMENT_STYLES, ((Chart)chart).getElementStyles());
    }
}

