/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.heatmap;

import com.twosigma.beakerx.chart.AbstractChart;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.GradientColor;
import com.twosigma.beakerx.chart.legend.LegendLayout;
import com.twosigma.beakerx.chart.legend.LegendPosition;

public class HeatMap
extends AbstractChart {
    private Number[][] data;
    private GradientColor color = GradientColor.BROWN_RED_YELLOW;

    public HeatMap() {
        this.setXLowerMargin(0.0);
        this.setXUpperMargin(0.0);
        this.setYLowerMargin(0.0);
        this.setYUpperMargin(0.0);
        this.setLegendLayout(LegendLayout.HORIZONTAL);
        this.setLegendPosition(LegendPosition.BOTTOM_RIGHT);
        this.openComm();
    }

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }

    public void setColor(GradientColor color) {
        this.color = color;
        this.sendModelUpdate(ChartToJson.serializeHeatmapGradientColor(this.color));
    }

    public GradientColor getColor() {
        return this.color;
    }

    public Number[][] getData() {
        return this.data;
    }

    public void setData(Number[][] data) {
        this.data = data;
        this.sendModelUpdate(ChartToJson.serializeHeatmapData(this.data));
    }
}

