/*
 * Decompiled with CFR 0.152.
 */
package com.sharejoys.crashlib.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.FileProvider;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CrashFileHelper {
    private static final String TAG = "CrashFileHelper";
    public static final String FILE_PROVIDER_NAME = "fileprovider";
    private static String FILE_NAME = "userIcon.jpg";
    public static String PATH_PHOTOGRAPH = "/smt/";

    public static String getSDPath() {
        File sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory();
        }
        return sdDir.toString();
    }

    public static String getRandomFileName() {
        Date todate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return sdf.format(todate);
    }

    public static void createDirs(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(Bitmap bitmap, String filePath) {
        FileOutputStream bos = null;
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            bos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.flush();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getDCIMFile(String filePath, String imageName) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File file;
            File dirs = new File(Environment.getExternalStorageDirectory(), "DCIM" + filePath);
            if (!dirs.exists()) {
                dirs.mkdirs();
            }
            if (!(file = new File(Environment.getExternalStorageDirectory(), "DCIM" + filePath + imageName)).exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveBitmap2(Bitmap bitmap, String fileName, File baseFile) {
        FileOutputStream bos = null;
        File imgFile = new File(baseFile, "/" + fileName);
        try {
            bos = new FileOutputStream(imgFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.flush();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return imgFile;
    }

    public static File getBaseFile(String filePath) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File f = new File(Environment.getExternalStorageDirectory(), filePath);
            if (!f.exists()) {
                f.mkdirs();
            }
            return f;
        }
        return null;
    }

    public static String getFileName() {
        String fileName = FILE_NAME;
        return fileName;
    }

    public static File createFile(String path, String name) throws IOException {
        File file;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(file = new File(path + name)).exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static Uri getUri(Context context, File file) {
        Uri uri = Build.VERSION.SDK_INT >= 23 ? FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + "." + FILE_PROVIDER_NAME), (File)file) : Uri.fromFile((File)file);
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFiles(File[] fs, String zipFilePath) {
        if (fs == null) {
            throw new NullPointerException("fs == null");
        }
        boolean result = false;
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFilePath)));
            for (File file : fs) {
                if (file == null || !file.exists() || file.getName().toLowerCase().endsWith("zip")) continue;
                if (file.isDirectory()) {
                    CrashFileHelper.recursionZip(zos, file, file.getName() + File.separator);
                    continue;
                }
                CrashFileHelper.recursionZip(zos, file, "");
            }
            result = true;
            zos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("zip file failed err: " + e.getMessage()));
        }
        finally {
            try {
                if (zos != null) {
                    zos.closeEntry();
                    zos.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return result;
    }

    private static void recursionZip(ZipOutputStream zipOut, File file, String baseDir) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            Log.i((String)TAG, (String)("the file is dir name -->>" + file.getName() + " the baseDir-->>>" + baseDir));
            for (File fileSec : files = file.listFiles()) {
                if (fileSec == null) continue;
                if (fileSec.isDirectory()) {
                    baseDir = file.getName() + File.separator + fileSec.getName() + File.separator;
                    Log.i((String)TAG, (String)("basDir111-->>" + baseDir));
                    CrashFileHelper.recursionZip(zipOut, fileSec, baseDir);
                    continue;
                }
                Log.i((String)TAG, (String)("basDir222-->>" + baseDir));
                CrashFileHelper.recursionZip(zipOut, fileSec, baseDir);
            }
        } else {
            int len;
            Log.i((String)TAG, (String)("the file name is -->>" + file.getName() + " the base dir -->>" + baseDir));
            byte[] buf = new byte[2048];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            zipOut.putNextEntry(new ZipEntry(baseDir + file.getName()));
            while ((len = ((InputStream)input).read(buf)) != -1) {
                zipOut.write(buf, 0, len);
            }
            ((InputStream)input).close();
        }
    }

    public static String getDataSize(long var0) {
        DecimalFormat var2 = new DecimalFormat("###.00");
        return var0 < 1024L ? var0 + "bytes" : (var0 < 0x100000L ? var2.format((float)var0 / 1024.0f) + "KB" : (var0 < 0x40000000L ? var2.format((float)var0 / 1024.0f / 1024.0f) + "MB" : (var0 < 0L ? var2.format((float)var0 / 1024.0f / 1024.0f / 1024.0f) + "GB" : "error")));
    }
}

