/*
 * Decompiled with CFR 0.152.
 */
package com.sharejoys.crashlib.ui;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import com.sharejoys.crashlib.CrashManager;
import com.sharejoys.crashlib.R;

public class ShowExceptionActivity
extends Activity {
    private static final String KEY_CRASH_INFO = "key_crash_info";
    private TextView exceptionView;

    public static void showException(String crashInfo) {
        Application applicationContext = CrashManager.getInstance().getApplication();
        if (applicationContext != null) {
            Intent intent = new Intent((Context)applicationContext, ShowExceptionActivity.class);
            intent.addFlags(0x10000000);
            intent.putExtra(KEY_CRASH_INFO, crashInfo);
            applicationContext.startActivity(intent);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crash_lib_activity_show_exception);
        this.setListener();
        int exceptionId = this.getResources().getIdentifier("crash_lib_activity_show_exception_view", "id", this.getPackageName());
        this.exceptionView = (TextView)this.findViewById(exceptionId);
        this.handlerIntent(this.getIntent(), false);
    }

    private void setListener() {
        int backBtnId = this.getResources().getIdentifier("crash_lib_activity_back_btn", "id", this.getPackageName());
        int shareBtnId = this.getResources().getIdentifier("crash_lib_activity_share_btn", "id", this.getPackageName());
        this.findViewById(backBtnId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ShowExceptionActivity.this.finish();
            }
        });
        this.findViewById(shareBtnId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CrashManager.getInstance().shareCrashFile(ShowExceptionActivity.this);
            }
        });
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.handlerIntent(intent, true);
    }

    private void handlerIntent(Intent intent, boolean isNew) {
        String msg = intent.getStringExtra(KEY_CRASH_INFO);
        if (msg != null) {
            if (isNew) {
                this.exceptionView.append((CharSequence)"\n\n\n\n\n\n");
            }
            this.exceptionView.append((CharSequence)msg);
        }
    }
}

