/*
 * Decompiled with CFR 0.152.
 */
package com.sharejoys.crashlib;

import android.app.Activity;
import android.app.Application;
import com.sharejoys.crashlib.ui.ExceptionCaughtAdapter;
import com.sharejoys.crashlib.util.CrashHelper;

public class CrashManager {
    private static final CrashManager gInstance = new CrashManager();
    private Application application;
    private boolean isDebug = true;

    public static CrashManager getInstance() {
        return gInstance;
    }

    public Application getApplication() {
        return this.application;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    private CrashManager() {
    }

    public void init(Application application, boolean isDebug) {
        this.application = application;
        this.isDebug = isDebug;
        CrashHelper.init();
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        ExceptionCaughtAdapter exceptionCaughtAdapter = new ExceptionCaughtAdapter(handler);
        Thread.setDefaultUncaughtExceptionHandler(exceptionCaughtAdapter);
    }

    public void shareCrashFile(Activity activity) {
        if (this.application == null) {
            throw new IllegalStateException("CrashManager\u5c1a\u672a\u88ab\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528init\u5b8c\u6210\u521d\u59cb\u5316\uff01\uff01\uff01\uff01");
        }
        CrashHelper.shareCrashFile(activity);
    }
}

