/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.graphics.Color;
import android.opengl.GLES20;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.filter.TwoParameterFilter;
import com.otaliastudios.opengl.core.Egloo;

public class DuotoneFilter
extends BaseFilter
implements TwoParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform vec3 first;\nuniform vec3 second;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  float energy = (color.r + color.g + color.b) * 0.3333;\n  vec3 new_color = (1.0 - energy) * first + energy * second;\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n";
    private int mFirstColor = -65281;
    private int mSecondColor = -256;
    private int mFirstColorLocation = -1;
    private int mSecondColorLocation = -1;

    public void setColors(@ColorInt int firstColor, @ColorInt int secondColor) {
        this.setFirstColor(firstColor);
        this.setSecondColor(secondColor);
    }

    public void setFirstColor(@ColorInt int color) {
        this.mFirstColor = Color.rgb((int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    public void setSecondColor(@ColorInt int color) {
        this.mSecondColor = Color.rgb((int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    @ColorInt
    public int getFirstColor() {
        return this.mFirstColor;
    }

    @ColorInt
    public int getSecondColor() {
        return this.mSecondColor;
    }

    @Override
    public void setParameter1(float value) {
        this.setFirstColor((int)(value * 1.6777215E7f));
    }

    @Override
    public float getParameter1() {
        int color = this.getFirstColor();
        color = Color.argb((int)0, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
        return (float)color / 1.6777215E7f;
    }

    @Override
    public void setParameter2(float value) {
        this.setSecondColor((int)(value * 1.6777215E7f));
    }

    @Override
    public float getParameter2() {
        int color = this.getSecondColor();
        color = Color.argb((int)0, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
        return (float)color / 1.6777215E7f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.mFirstColorLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"first");
        Egloo.checkGlProgramLocation((int)this.mFirstColorLocation, (String)"first");
        this.mSecondColorLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"second");
        Egloo.checkGlProgramLocation((int)this.mSecondColorLocation, (String)"second");
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        float[] first = new float[]{(float)Color.red((int)this.mFirstColor) / 255.0f, (float)Color.green((int)this.mFirstColor) / 255.0f, (float)Color.blue((int)this.mFirstColor) / 255.0f};
        float[] second = new float[]{(float)Color.red((int)this.mSecondColor) / 255.0f, (float)Color.green((int)this.mSecondColor) / 255.0f, (float)Color.blue((int)this.mSecondColor) / 255.0f};
        GLES20.glUniform3fv((int)this.mFirstColorLocation, (int)1, (float[])first, (int)0);
        Egloo.checkGlError((String)"glUniform3fv");
        GLES20.glUniform3fv((int)this.mSecondColorLocation, (int)1, (float[])second, (int)0);
        Egloo.checkGlError((String)"glUniform3fv");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mFirstColorLocation = -1;
        this.mSecondColorLocation = -1;
    }
}

