/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.tree;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.tree.Algorithm;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.exception.DnsException;
import org.tron.p2p.utils.ByteArray;

public class LinkEntry
implements Entry {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final String represent;
    private final String domain;
    private final String unCompressHexPublicKey;

    public LinkEntry(String represent, String domain, String unCompressHexPublicKey) {
        this.represent = represent;
        this.domain = domain;
        this.unCompressHexPublicKey = unCompressHexPublicKey;
    }

    public static LinkEntry parseEntry(String treeRepresent) throws DnsException {
        if (!treeRepresent.startsWith("tree://")) {
            throw new DnsException(DnsException.TypeEnum.INVALID_SCHEME_URL, "scheme url must starts with :[tree://], but get " + treeRepresent);
        }
        String[] items = treeRepresent.substring("tree://".length()).split("@");
        if (items.length != 2) {
            throw new DnsException(DnsException.TypeEnum.NO_PUBLIC_KEY, "scheme url:" + treeRepresent);
        }
        String base32PublicKey = items[0];
        try {
            byte[] data = Algorithm.decode32(base32PublicKey);
            String unCompressPublicKey = Algorithm.decompressPubKey(ByteArray.toHexString(data));
            return new LinkEntry(treeRepresent, items[1], unCompressPublicKey);
        }
        catch (RuntimeException exception) {
            throw new DnsException(DnsException.TypeEnum.BAD_PUBLIC_KEY, "bad public key:" + base32PublicKey);
        }
    }

    public static String buildRepresent(String base32PubKey, String domain) {
        return "tree://" + base32PubKey + "@" + domain;
    }

    public String toString() {
        return this.represent;
    }

    public String getRepresent() {
        return this.represent;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUnCompressHexPublicKey() {
        return this.unCompressHexPublicKey;
    }
}

