/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.socket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.discover.message.Message;
import org.tron.p2p.discover.socket.UdpEvent;
import org.tron.p2p.exception.P2pException;

public class P2pPacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static final int MAXSIZE = 2048;

    public void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        int length = buf.readableBytes();
        if (length <= 1 || length >= 2048) {
            log.warn("UDP rcv bad packet, from {} length = {}", (Object)ctx.channel().remoteAddress(), (Object)length);
            return;
        }
        byte[] encoded = new byte[length];
        buf.readBytes(encoded);
        try {
            UdpEvent event = new UdpEvent(Message.parse(encoded), (InetSocketAddress)packet.sender());
            out.add(event);
        }
        catch (P2pException pe) {
            if (pe.getType().equals((Object)P2pException.TypeEnum.BAD_MESSAGE)) {
                log.error("Message validation failed, type {}, len {}, address {}", new Object[]{encoded[0], encoded.length, packet.sender()});
            } else {
                log.info("Parse msg failed, type {}, len {}, address {}", new Object[]{encoded[0], encoded.length, packet.sender()});
            }
        }
        catch (Exception e) {
            log.error("An exception occurred while parsing the message, type {}, len {}, address {}", new Object[]{encoded[0], encoded.length, packet.sender(), e});
        }
    }
}

