/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.protocol.kad.table;

import org.tron.p2p.discover.Node;

public class NodeEntry {
    private Node node;
    private String entryId;
    private int distance;
    private long modified;

    public NodeEntry(byte[] ownerId, Node n) {
        this.node = n;
        this.entryId = n.getHostKey();
        this.distance = NodeEntry.distance(ownerId, n.getId());
        this.touch();
    }

    public static int distance(byte[] ownerId, byte[] targetId) {
        byte[] h1 = targetId;
        byte[] h2 = ownerId;
        byte[] hash = new byte[Math.min(h1.length, h2.length)];
        for (int i = 0; i < hash.length; ++i) {
            hash[i] = (byte)(h1[i] ^ h2[i]);
        }
        int d = 17;
        for (byte b : hash) {
            if (b == 0) {
                d -= 8;
                continue;
            }
            int count = 0;
            for (int i = 7; i >= 0; --i) {
                boolean a;
                boolean bl = a = (b & 0xFF & 1 << i) == 0;
                if (!a) break;
                ++count;
            }
            d -= count;
            break;
        }
        return d;
    }

    public void touch() {
        this.modified = System.currentTimeMillis();
    }

    public int getDistance() {
        return this.distance;
    }

    public String getId() {
        return this.entryId;
    }

    public Node getNode() {
        return this.node;
    }

    public long getModified() {
        return this.modified;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && this.getClass() == o.getClass()) {
            NodeEntry e = (NodeEntry)o;
            ret = this.getId().equals(e.getId());
        }
        return ret;
    }

    public int hashCode() {
        return this.entryId.hashCode();
    }
}

