/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.message.kad;

import java.util.ArrayList;
import java.util.List;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.message.MessageType;
import org.tron.p2p.discover.message.kad.KadMessage;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.NetUtil;

public class NeighborsMessage
extends KadMessage {
    private Discover.Neighbours neighbours;

    public NeighborsMessage(byte[] data) throws Exception {
        super(MessageType.KAD_NEIGHBORS, data);
        this.neighbours = Discover.Neighbours.parseFrom(data);
    }

    public NeighborsMessage(Node from, List<Node> neighbours, long sequence) {
        super(MessageType.KAD_NEIGHBORS, null);
        Discover.Neighbours.Builder builder = Discover.Neighbours.newBuilder().setTimestamp(sequence);
        neighbours.forEach(neighbour -> {
            Discover.Endpoint endpoint = NeighborsMessage.getEndpointFromNode(neighbour);
            builder.addNeighbours(endpoint);
        });
        Discover.Endpoint fromEndpoint = NeighborsMessage.getEndpointFromNode(from);
        builder.setFrom(fromEndpoint);
        this.neighbours = builder.build();
        this.data = this.neighbours.toByteArray();
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.neighbours.getNeighboursList().forEach(n -> nodes.add(NetUtil.getNode(n)));
        return nodes;
    }

    @Override
    public long getTimestamp() {
        return this.neighbours.getTimestamp();
    }

    @Override
    public Node getFrom() {
        return NetUtil.getNode(this.neighbours.getFrom());
    }

    @Override
    public String toString() {
        return "[neighbours: " + this.neighbours;
    }

    @Override
    public boolean valid() {
        if (!NetUtil.validNode(this.getFrom())) {
            return false;
        }
        if (this.getNodes().size() > 0) {
            if (this.getNodes().size() > 16) {
                return false;
            }
            for (Node node : this.getNodes()) {
                if (NetUtil.validNode(node)) continue;
                return false;
            }
        }
        return true;
    }
}

