/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.message.kad;

import com.google.protobuf.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.message.Message;
import org.tron.p2p.discover.message.MessageType;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.ByteArray;

public abstract class KadMessage
extends Message {
    protected KadMessage(MessageType type, byte[] data) {
        super(type, data);
    }

    public abstract Node getFrom();

    public abstract long getTimestamp();

    public static Discover.Endpoint getEndpointFromNode(Node node) {
        Discover.Endpoint.Builder builder = Discover.Endpoint.newBuilder().setPort(node.getPort());
        if (node.getId() != null) {
            builder.setNodeId(ByteString.copyFrom((byte[])node.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)node.getHostV4())) {
            builder.setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(node.getHostV4())));
        }
        if (StringUtils.isNotEmpty((CharSequence)node.getHostV6())) {
            builder.setAddressIpv6(ByteString.copyFrom((byte[])ByteArray.fromString(node.getHostV6())));
        }
        return builder.build();
    }
}

