/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.tron.p2p.dns.update.PublishConfig;
import org.tron.p2p.utils.NetUtil;

public class P2pConfig {
    private List<InetSocketAddress> seedNodes = new CopyOnWriteArrayList<InetSocketAddress>();
    private List<InetSocketAddress> activeNodes = new CopyOnWriteArrayList<InetSocketAddress>();
    private List<InetAddress> trustNodes = new CopyOnWriteArrayList<InetAddress>();
    private byte[] nodeID = NetUtil.getNodeId();
    private String ip = NetUtil.getExternalIpV4();
    private String ipv6 = NetUtil.getExternalIpV6();
    private int port = 18888;
    private int networkId = 1;
    private int minConnections = 8;
    private int maxConnections = 50;
    private int minActiveConnections = 2;
    private int maxConnectionsWithSameIp = 2;
    private boolean discoverEnable = true;
    private boolean disconnectionPolicyEnable = false;
    private boolean nodeDetectEnable = false;
    private List<String> treeUrls = new ArrayList<String>();
    private PublishConfig publishConfig = new PublishConfig();

    public List<InetSocketAddress> getSeedNodes() {
        return this.seedNodes;
    }

    public List<InetSocketAddress> getActiveNodes() {
        return this.activeNodes;
    }

    public List<InetAddress> getTrustNodes() {
        return this.trustNodes;
    }

    public byte[] getNodeID() {
        return this.nodeID;
    }

    public String getIp() {
        return this.ip;
    }

    public String getIpv6() {
        return this.ipv6;
    }

    public int getPort() {
        return this.port;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMinActiveConnections() {
        return this.minActiveConnections;
    }

    public int getMaxConnectionsWithSameIp() {
        return this.maxConnectionsWithSameIp;
    }

    public boolean isDiscoverEnable() {
        return this.discoverEnable;
    }

    public boolean isDisconnectionPolicyEnable() {
        return this.disconnectionPolicyEnable;
    }

    public boolean isNodeDetectEnable() {
        return this.nodeDetectEnable;
    }

    public List<String> getTreeUrls() {
        return this.treeUrls;
    }

    public PublishConfig getPublishConfig() {
        return this.publishConfig;
    }

    public void setSeedNodes(List<InetSocketAddress> seedNodes) {
        this.seedNodes = seedNodes;
    }

    public void setActiveNodes(List<InetSocketAddress> activeNodes) {
        this.activeNodes = activeNodes;
    }

    public void setTrustNodes(List<InetAddress> trustNodes) {
        this.trustNodes = trustNodes;
    }

    public void setNodeID(byte[] nodeID) {
        this.nodeID = nodeID;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMinActiveConnections(int minActiveConnections) {
        this.minActiveConnections = minActiveConnections;
    }

    public void setMaxConnectionsWithSameIp(int maxConnectionsWithSameIp) {
        this.maxConnectionsWithSameIp = maxConnectionsWithSameIp;
    }

    public void setDiscoverEnable(boolean discoverEnable) {
        this.discoverEnable = discoverEnable;
    }

    public void setDisconnectionPolicyEnable(boolean disconnectionPolicyEnable) {
        this.disconnectionPolicyEnable = disconnectionPolicyEnable;
    }

    public void setNodeDetectEnable(boolean nodeDetectEnable) {
        this.nodeDetectEnable = nodeDetectEnable;
    }

    public void setTreeUrls(List<String> treeUrls) {
        this.treeUrls = treeUrls;
    }

    public void setPublishConfig(PublishConfig publishConfig) {
        this.publishConfig = publishConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof P2pConfig)) {
            return false;
        }
        P2pConfig other = (P2pConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<InetSocketAddress> this$seedNodes = this.getSeedNodes();
        List<InetSocketAddress> other$seedNodes = other.getSeedNodes();
        if (this$seedNodes == null ? other$seedNodes != null : !((Object)this$seedNodes).equals(other$seedNodes)) {
            return false;
        }
        List<InetSocketAddress> this$activeNodes = this.getActiveNodes();
        List<InetSocketAddress> other$activeNodes = other.getActiveNodes();
        if (this$activeNodes == null ? other$activeNodes != null : !((Object)this$activeNodes).equals(other$activeNodes)) {
            return false;
        }
        List<InetAddress> this$trustNodes = this.getTrustNodes();
        List<InetAddress> other$trustNodes = other.getTrustNodes();
        if (this$trustNodes == null ? other$trustNodes != null : !((Object)this$trustNodes).equals(other$trustNodes)) {
            return false;
        }
        if (!Arrays.equals(this.getNodeID(), other.getNodeID())) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$ipv6 = this.getIpv6();
        String other$ipv6 = other.getIpv6();
        if (this$ipv6 == null ? other$ipv6 != null : !this$ipv6.equals(other$ipv6)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getNetworkId() != other.getNetworkId()) {
            return false;
        }
        if (this.getMinConnections() != other.getMinConnections()) {
            return false;
        }
        if (this.getMaxConnections() != other.getMaxConnections()) {
            return false;
        }
        if (this.getMinActiveConnections() != other.getMinActiveConnections()) {
            return false;
        }
        if (this.getMaxConnectionsWithSameIp() != other.getMaxConnectionsWithSameIp()) {
            return false;
        }
        if (this.isDiscoverEnable() != other.isDiscoverEnable()) {
            return false;
        }
        if (this.isDisconnectionPolicyEnable() != other.isDisconnectionPolicyEnable()) {
            return false;
        }
        if (this.isNodeDetectEnable() != other.isNodeDetectEnable()) {
            return false;
        }
        List<String> this$treeUrls = this.getTreeUrls();
        List<String> other$treeUrls = other.getTreeUrls();
        if (this$treeUrls == null ? other$treeUrls != null : !((Object)this$treeUrls).equals(other$treeUrls)) {
            return false;
        }
        PublishConfig this$publishConfig = this.getPublishConfig();
        PublishConfig other$publishConfig = other.getPublishConfig();
        return !(this$publishConfig == null ? other$publishConfig != null : !((Object)this$publishConfig).equals(other$publishConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof P2pConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<InetSocketAddress> $seedNodes = this.getSeedNodes();
        result = result * 59 + ($seedNodes == null ? 43 : ((Object)$seedNodes).hashCode());
        List<InetSocketAddress> $activeNodes = this.getActiveNodes();
        result = result * 59 + ($activeNodes == null ? 43 : ((Object)$activeNodes).hashCode());
        List<InetAddress> $trustNodes = this.getTrustNodes();
        result = result * 59 + ($trustNodes == null ? 43 : ((Object)$trustNodes).hashCode());
        result = result * 59 + Arrays.hashCode(this.getNodeID());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $ipv6 = this.getIpv6();
        result = result * 59 + ($ipv6 == null ? 43 : $ipv6.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + this.getNetworkId();
        result = result * 59 + this.getMinConnections();
        result = result * 59 + this.getMaxConnections();
        result = result * 59 + this.getMinActiveConnections();
        result = result * 59 + this.getMaxConnectionsWithSameIp();
        result = result * 59 + (this.isDiscoverEnable() ? 79 : 97);
        result = result * 59 + (this.isDisconnectionPolicyEnable() ? 79 : 97);
        result = result * 59 + (this.isNodeDetectEnable() ? 79 : 97);
        List<String> $treeUrls = this.getTreeUrls();
        result = result * 59 + ($treeUrls == null ? 43 : ((Object)$treeUrls).hashCode());
        PublishConfig $publishConfig = this.getPublishConfig();
        result = result * 59 + ($publishConfig == null ? 43 : ((Object)$publishConfig).hashCode());
        return result;
    }

    public String toString() {
        return "P2pConfig(seedNodes=" + this.getSeedNodes() + ", activeNodes=" + this.getActiveNodes() + ", trustNodes=" + this.getTrustNodes() + ", nodeID=" + Arrays.toString(this.getNodeID()) + ", ip=" + this.getIp() + ", ipv6=" + this.getIpv6() + ", port=" + this.getPort() + ", networkId=" + this.getNetworkId() + ", minConnections=" + this.getMinConnections() + ", maxConnections=" + this.getMaxConnections() + ", minActiveConnections=" + this.getMinActiveConnections() + ", maxConnectionsWithSameIp=" + this.getMaxConnectionsWithSameIp() + ", discoverEnable=" + this.isDiscoverEnable() + ", disconnectionPolicyEnable=" + this.isDisconnectionPolicyEnable() + ", nodeDetectEnable=" + this.isNodeDetectEnable() + ", treeUrls=" + this.getTreeUrls() + ", publishConfig=" + this.getPublishConfig() + ")";
    }
}

