/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ArchiveManifest
implements Callable<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger((String)"archive");
    private static final String KEY_ENGINE = "ENGINE";
    private static final String LEVELDB = "LEVELDB";
    private final Path srcDbPath;
    private final String name;
    private final Options options;
    private final long startTime;
    private static final int CPUS = Runtime.getRuntime().availableProcessors();

    public ArchiveManifest(String src, String name, int maxManifestSize, int maxBatchSize) {
        this.name = name;
        this.srcDbPath = Paths.get(src, name);
        this.startTime = System.currentTimeMillis();
        this.options = ArchiveManifest.newDefaultLevelDbOptions();
        this.options.maxManifestSize(maxManifestSize);
        this.options.maxBatchSize(maxBatchSize);
    }

    @Override
    public Boolean call() throws Exception {
        return this.doArchive();
    }

    public static Options newDefaultLevelDbOptions() {
        Options dbOptions = new Options();
        dbOptions.createIfMissing(true);
        dbOptions.paranoidChecks(true);
        dbOptions.verifyChecksums(true);
        dbOptions.compressionType(CompressionType.SNAPPY);
        dbOptions.blockSize(4096);
        dbOptions.writeBufferSize(0xA00000);
        dbOptions.cacheSize(0xA00000L);
        dbOptions.maxOpenFiles(1000);
        dbOptions.maxBatchSize(64000);
        dbOptions.maxManifestSize(128);
        return dbOptions;
    }

    public static void main(String[] args) {
        int code = ArchiveManifest.run(args);
        logger.info("exit code {}.", (Object)code);
        System.out.printf("exit code %d.\n", code);
        System.exit(code);
    }

    public static int run(String[] args) {
        Args parameters = new Args();
        CommandLine commandLine = new CommandLine((Object)parameters);
        commandLine.parseArgs(args);
        if (parameters.help) {
            commandLine.usage(System.out);
            return 0;
        }
        File dbDirectory = new File(parameters.databaseDirectory);
        if (!dbDirectory.exists()) {
            logger.info("Directory {} does not exist.", (Object)parameters.databaseDirectory);
            return 404;
        }
        if (!dbDirectory.isDirectory()) {
            logger.info("{} is not directory.", (Object)parameters.databaseDirectory);
            return 405;
        }
        List<File> files = Arrays.stream((Object[])Objects.requireNonNull(dbDirectory.listFiles())).filter(File::isDirectory).collect(Collectors.toList());
        if (files.isEmpty()) {
            logger.info("Directory {} does not contain any database.", (Object)parameters.databaseDirectory);
            return 0;
        }
        long time = System.currentTimeMillis();
        ArrayList res = new ArrayList();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(CPUS, 16 * CPUS, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(CPUS, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        executor.allowCoreThreadTimeOut(true);
        files.forEach(f -> res.add(executor.submit(new ArchiveManifest(parameters.databaseDirectory, f.getName(), parameters.maxManifestSize, parameters.maxBatchSize))));
        int fails = res.size();
        for (Future re : res) {
            try {
                if (!Boolean.TRUE.equals(re.get())) continue;
                --fails;
            }
            catch (InterruptedException e) {
                logger.error("{}", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                logger.error("{}", (Throwable)e);
            }
        }
        executor.shutdown();
        logger.info("DatabaseDirectory:{}, maxManifestSize:{}, maxBatchSize:{},database reopen use {} seconds total.", new Object[]{parameters.databaseDirectory, parameters.maxManifestSize, parameters.maxBatchSize, (System.currentTimeMillis() - time) / 1000L});
        if (fails > 0) {
            logger.error("Failed!!!!!!!!!!!!!!!!!!!!!!!! size:{}", (Object)fails);
        }
        return fails;
    }

    public void open() throws IOException {
        DB database = Iq80DBFactory.factory.open(this.srcDbPath.toFile(), this.options);
        database.close();
    }

    public boolean checkManifest(String dir) throws IOException {
        File currentFile = new File(dir, Filename.currentFileName());
        if (!currentFile.exists()) {
            return false;
        }
        String currentName = Files.asCharSource((File)currentFile, (Charset)StandardCharsets.UTF_8).read();
        if (currentName.isEmpty() || currentName.charAt(currentName.length() - 1) != '\n') {
            return false;
        }
        File current = new File(dir, currentName = currentName.substring(0, currentName.length() - 1));
        if (!current.isFile()) {
            return false;
        }
        long maxSize = this.options.maxManifestSize();
        if (maxSize < 0L) {
            return false;
        }
        logger.info("CurrentName {}/{},size {} kb.", new Object[]{dir, currentName, current.length() / 1024L});
        if ("market_pair_price_to_order".equalsIgnoreCase(this.name)) {
            logger.info("Db {} ignored.", (Object)this.name);
            return false;
        }
        return current.length() >= maxSize * 1024L * 1024L;
    }

    public boolean doArchive() throws IOException {
        File levelDbFile = this.srcDbPath.toFile();
        if (!levelDbFile.exists()) {
            logger.info("File {},does not exist, ignored.", (Object)this.srcDbPath.toString());
            return true;
        }
        if (!this.checkManifest(levelDbFile.toString())) {
            logger.info("Db {},no need, ignored.", (Object)levelDbFile.toString());
            return true;
        }
        if (!this.checkEngine()) {
            logger.info("Db {},not leveldb, ignored.", (Object)this.name);
            return true;
        }
        this.open();
        logger.info("Db {} archive use {} ms.", (Object)this.name, (Object)(System.currentTimeMillis() - this.startTime));
        return true;
    }

    public boolean checkEngine() {
        String dir = this.srcDbPath.toString();
        String enginePath = dir + File.separator + "engine.properties";
        if (!new File(enginePath).exists() && !ArchiveManifest.writeProperty(enginePath, KEY_ENGINE, LEVELDB)) {
            return false;
        }
        String engine = ArchiveManifest.readProperty(enginePath, KEY_ENGINE);
        return LEVELDB.equals(engine);
    }

    /*
     * Exception decompiling
     */
    public static String readProperty(String file, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean writeProperty(String file, String key, String value) {
        try (FileOutputStream out = new FileOutputStream(file);
             FileInputStream fis = new FileInputStream(file);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            Properties properties = new Properties();
            properties.load(bf);
            properties.setProperty(key, value);
            properties.store(bw, "Generated by the application.  PLEASE DO NOT EDIT! ");
        }
        catch (Exception e) {
            logger.warn("{}", (Throwable)e);
            return false;
        }
        return true;
    }

    public static class Args {
        @CommandLine.Option(names={"-d", "--database-directory"}, defaultValue="output-directory/database", description={"java-tron database directory. Default: ${DEFAULT-VALUE}"})
        private String databaseDirectory;
        @CommandLine.Option(names={"-b", "--batch-size"}, defaultValue="80000", description={"deal manifest batch size. Default: ${DEFAULT-VALUE}"})
        private int maxBatchSize;
        @CommandLine.Option(names={"-m", "--manifest-size"}, defaultValue="0", description={"manifest  min size(M) to archive. Default: ${DEFAULT-VALUE}"})
        private int maxManifestSize;
        @CommandLine.Option(names={"-h", "--help"}, help=true)
        private boolean help;
    }
}

