/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tool.litefullnode.db;

import java.io.IOException;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.tron.tool.litefullnode.db.DBInterface;
import org.tron.tool.litefullnode.iterator.DBIterator;
import org.tron.tool.litefullnode.iterator.RockDBIterator;

public class RocksDBImpl
implements DBInterface {
    private RocksDB rocksDB;

    public RocksDBImpl(RocksDB rocksDB) {
        this.rocksDB = rocksDB;
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.rocksDB.get(key);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void put(byte[] key, byte[] value) {
        try {
            this.rocksDB.put(key, value);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete(byte[] key) {
        try {
            this.rocksDB.delete(key);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DBIterator iterator() {
        return new RockDBIterator(this.rocksDB.newIterator());
    }

    @Override
    public long size() {
        RocksIterator iterator = this.rocksDB.newIterator();
        long size = 0L;
        iterator.seekToFirst();
        while (iterator.isValid()) {
            ++size;
            iterator.next();
        }
        iterator.close();
        return size;
    }

    @Override
    public void close() throws IOException {
        this.rocksDB.close();
    }
}

