/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.note;

import java.math.BigInteger;
import java.util.Optional;
import org.tron.common.utils.ByteUtil;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.JLibsodium;
import org.tron.common.zksnark.JLibsodiumParam;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.DiversifierT;

public class NoteEncryption {
    private byte[] epk;
    private byte[] esk;
    private boolean alreadyEncryptedEnc;
    private boolean alreadyEncryptedOut;

    public NoteEncryption(byte[] epk, byte[] esk) {
        this.epk = epk;
        this.esk = esk;
    }

    public static Optional<NoteEncryption> fromDiversifier(DiversifierT d) throws ZksnarkException {
        byte[] epk = new byte[32];
        byte[] esk = new byte[32];
        JLibrustzcash.librustzcashSaplingGenerateR((byte[])esk);
        if (!JLibrustzcash.librustzcashSaplingKaDerivepublic((LibrustzcashParam.KaDerivepublicParams)new LibrustzcashParam.KaDerivepublicParams(d.getData(), esk, epk))) {
            return Optional.empty();
        }
        return Optional.of(new NoteEncryption(epk, esk));
    }

    public Optional<Encryption.EncCiphertext> encryptToRecipient(byte[] pkD, Encryption.EncPlaintext message) throws ZksnarkException {
        if (this.alreadyEncryptedEnc) {
            throw new ZksnarkException("already encrypted to the recipient using this key");
        }
        byte[] dhsecret = new byte[32];
        if (!JLibrustzcash.librustzcashKaAgree((LibrustzcashParam.KaAgreeParams)new LibrustzcashParam.KaAgreeParams(pkD, this.esk, dhsecret))) {
            return Optional.empty();
        }
        byte[] kEnc = new byte[32];
        Encryption.kdfSapling(kEnc, dhsecret, this.epk);
        byte[] cipherNonce = new byte[12];
        Encryption.EncCiphertext ciphertext = new Encryption.EncCiphertext();
        JLibsodium.cryptoAeadChacha20Poly1305IetfEncrypt((JLibsodiumParam.Chacha20Poly1305IetfEncryptParams)new JLibsodiumParam.Chacha20Poly1305IetfEncryptParams(ciphertext.data, null, message.data, 564L, null, 0L, null, cipherNonce, kEnc));
        this.alreadyEncryptedEnc = true;
        return Optional.of(ciphertext);
    }

    public Encryption.OutCiphertext encryptToOurselves(byte[] ovk, byte[] cv, byte[] cm, Encryption.OutPlaintext message) throws ZksnarkException {
        if (this.alreadyEncryptedOut) {
            throw new ZksnarkException("already encrypted to the recipient using this key");
        }
        byte[] ock = new byte[32];
        Encryption.prfOck(ock, ovk, cv, cm, this.epk);
        byte[] cipherNonce = new byte[12];
        Encryption.OutCiphertext ciphertext = new Encryption.OutCiphertext();
        JLibsodium.cryptoAeadChacha20Poly1305IetfEncrypt((JLibsodiumParam.Chacha20Poly1305IetfEncryptParams)new JLibsodiumParam.Chacha20Poly1305IetfEncryptParams(ciphertext.data, null, message.data, 64L, null, 0L, null, cipherNonce, ock));
        this.alreadyEncryptedOut = true;
        return ciphertext;
    }

    public NoteEncryption(byte[] epk, byte[] esk, boolean alreadyEncryptedEnc, boolean alreadyEncryptedOut) {
        this.epk = epk;
        this.esk = esk;
        this.alreadyEncryptedEnc = alreadyEncryptedEnc;
        this.alreadyEncryptedOut = alreadyEncryptedOut;
    }

    public byte[] getEpk() {
        return this.epk;
    }

    public byte[] getEsk() {
        return this.esk;
    }

    public static class Encryption {
        public static final int NOTEENCRYPTION_CIPHER_KEYSIZE = 32;

        public static void prfOck(byte[] ock, byte[] ovk, byte[] cv, byte[] cm, byte[] epk) throws ZksnarkException {
            byte[] block = new byte[128];
            System.arraycopy(ovk, 0, block, 0, 32);
            System.arraycopy(cv, 0, block, 32, 32);
            System.arraycopy(cm, 0, block, 64, 32);
            System.arraycopy(epk, 0, block, 96, 32);
            byte[] personalization = new byte[16];
            byte[] temp = "Ztron_Derive_ock".getBytes();
            System.arraycopy(temp, 0, personalization, 0, temp.length);
            if (JLibsodium.cryptoGenerichashBlack2bSaltPersonal((JLibsodiumParam.Black2bSaltPersonalParams)new JLibsodiumParam.Black2bSaltPersonalParams(ock, 32, block, 128L, null, 0, null, personalization)) != 0) {
                throw new ZksnarkException("hash function failure");
            }
        }

        public static void kdfSapling(byte[] kEnc, byte[] sharedsecret, byte[] epk) throws ZksnarkException {
            byte[] block = new byte[64];
            System.arraycopy(sharedsecret, 0, block, 0, 32);
            System.arraycopy(epk, 0, block, 32, 32);
            byte[] personalization = new byte[16];
            byte[] temp = "Ztron_SaplingKDF".getBytes();
            System.arraycopy(temp, 0, personalization, 0, temp.length);
            if (JLibsodium.cryptoGenerichashBlack2bSaltPersonal((JLibsodiumParam.Black2bSaltPersonalParams)new JLibsodiumParam.Black2bSaltPersonalParams(kEnc, 32, block, 64L, null, 0, null, personalization)) != 0) {
                throw new ZksnarkException("hash function failure");
            }
        }

        public static Optional<EncPlaintext> attemptEncDecryption(byte[] ciphertext, byte[] ivk, byte[] epk) throws ZksnarkException {
            byte[] sharedsecret = new byte[32];
            if (!JLibrustzcash.librustzcashKaAgree((LibrustzcashParam.KaAgreeParams)new LibrustzcashParam.KaAgreeParams(epk, ivk, sharedsecret))) {
                return Optional.empty();
            }
            byte[] kEnc = new byte[32];
            Encryption.kdfSapling(kEnc, sharedsecret, epk);
            byte[] cipher_nonce = new byte[12];
            EncPlaintext plaintext = new EncPlaintext();
            EncPlaintext.access$102(plaintext, new byte[564]);
            if (JLibsodium.cryptoAeadChacha20poly1305IetfDecrypt((JLibsodiumParam.Chacha20poly1305IetfDecryptParams)new JLibsodiumParam.Chacha20poly1305IetfDecryptParams(plaintext.data, null, null, ciphertext, 580L, null, 0L, cipher_nonce, kEnc)) != 0) {
                return Optional.empty();
            }
            return Optional.of(plaintext);
        }

        public static Optional<EncPlaintext> attemptEncDecryption(EncCiphertext ciphertext, byte[] epk, byte[] esk, byte[] pkD) throws ZksnarkException {
            byte[] sharedsecret = new byte[32];
            if (!JLibrustzcash.librustzcashKaAgree((LibrustzcashParam.KaAgreeParams)new LibrustzcashParam.KaAgreeParams(pkD, esk, sharedsecret))) {
                return Optional.empty();
            }
            byte[] kEnc = new byte[32];
            Encryption.kdfSapling(kEnc, sharedsecret, epk);
            byte[] cipherNonce = new byte[12];
            EncPlaintext plaintext = new EncPlaintext();
            EncPlaintext.access$102(plaintext, new byte[564]);
            if (JLibsodium.cryptoAeadChacha20poly1305IetfDecrypt((JLibsodiumParam.Chacha20poly1305IetfDecryptParams)new JLibsodiumParam.Chacha20poly1305IetfDecryptParams(plaintext.data, null, null, ciphertext.data, 580L, null, 0L, cipherNonce, kEnc)) != 0) {
                return Optional.empty();
            }
            return Optional.of(plaintext);
        }

        public static Optional<OutPlaintext> attemptOutDecryption(OutCiphertext ciphertext, byte[] ovk, byte[] cv, byte[] cm, byte[] epk) throws ZksnarkException {
            byte[] ock = new byte[32];
            Encryption.prfOck(ock, ovk, cv, cm, epk);
            byte[] cipherNonce = new byte[12];
            OutPlaintext plaintext = new OutPlaintext();
            OutPlaintext.access$302(plaintext, new byte[64]);
            if (JLibsodium.cryptoAeadChacha20poly1305IetfDecrypt((JLibsodiumParam.Chacha20poly1305IetfDecryptParams)new JLibsodiumParam.Chacha20poly1305IetfDecryptParams(plaintext.data, null, null, ciphertext.data, 80L, null, 0L, cipherNonce, ock)) != 0) {
                return Optional.empty();
            }
            return Optional.of(plaintext);
        }

        public static Optional<byte[]> encryptBurnMessageByOvk(byte[] ovk, BigInteger toAmount, byte[] transparentToAddress) throws ZksnarkException {
            byte[] plaintext = new byte[64];
            byte[] amountArray = ByteUtil.bigIntegerToBytes((BigInteger)toAmount, (int)32);
            byte[] cipherNonce = new byte[12];
            byte[] cipher = new byte[80];
            System.arraycopy(amountArray, 0, plaintext, 0, 32);
            System.arraycopy(transparentToAddress, 0, plaintext, 32, 21);
            if (JLibsodium.cryptoAeadChacha20Poly1305IetfEncrypt((JLibsodiumParam.Chacha20Poly1305IetfEncryptParams)new JLibsodiumParam.Chacha20Poly1305IetfEncryptParams(cipher, null, plaintext, 64L, null, 0L, null, cipherNonce, ovk)) != 0) {
                return Optional.empty();
            }
            return Optional.of(cipher);
        }

        public static Optional<byte[]> decryptBurnMessageByOvk(byte[] ovk, byte[] ciphertext) throws ZksnarkException {
            byte[] outPlaintext = new byte[64];
            byte[] cipherNonce = new byte[12];
            if (JLibsodium.cryptoAeadChacha20poly1305IetfDecrypt((JLibsodiumParam.Chacha20poly1305IetfDecryptParams)new JLibsodiumParam.Chacha20poly1305IetfDecryptParams(outPlaintext, null, null, ciphertext, 80L, null, 0L, cipherNonce, ovk)) != 0) {
                return Optional.empty();
            }
            return Optional.of(outPlaintext);
        }

        public static class OutPlaintext {
            private byte[] data = new byte[64];

            public byte[] getData() {
                return this.data;
            }

            public void setData(byte[] data) {
                this.data = data;
            }

            static /* synthetic */ byte[] access$302(OutPlaintext x0, byte[] x1) {
                x0.data = x1;
                return x1;
            }
        }

        public static class OutCiphertext {
            private byte[] data = new byte[80];

            public byte[] getData() {
                return this.data;
            }

            public void setData(byte[] data) {
                this.data = data;
            }
        }

        public static class EncPlaintext {
            private byte[] data = new byte[564];

            public byte[] getData() {
                return this.data;
            }

            public void setData(byte[] data) {
                this.data = data;
            }

            static /* synthetic */ byte[] access$102(EncPlaintext x0, byte[] x1) {
                x0.data = x1;
                return x1;
            }
        }

        public static class EncCiphertext {
            private byte[] data = new byte[580];

            public byte[] getData() {
                return this.data;
            }

            public void setData(byte[] data) {
                this.data = data;
            }
        }
    }
}

